package com.elitesland.fin.application.facade.vo.financial;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 充值单;
 *
 * @author : http://www.chiner.pro
 * @date : 2023-2-20
 */
@ApiModel(value = "账单", description = "")
@Data
public class ManagementFeeBillVO extends BaseModelVO {
    private static final long serialVersionUID = 4643188476671438315L;

    @ApiModelProperty("账户号")
    private String accountNo;

    @ApiModelProperty("记账日期 (格式: yyyy-MM-dd HH:mm:ss)")
    private String accountTime;

    @ApiModelProperty("收支类型")
    private String dcType;

    @ApiModelProperty("收支编码")
    @SysCode(sys = "yst-fin", mod = "DC_CODE_TYPE")
    private String dcCode;
    private String dcCodeName;

    @ApiModelProperty("收支名称")
    private String dcName;

    @ApiModelProperty("账户类型")
    private String accountType;

    @ApiModelProperty("平台流水号")
    private String bussNo;

    @ApiModelProperty("云资金流水号")
    private String slBussNo;

    @ApiModelProperty("外部业务单号")
    private String outBussNo;

    @ApiModelProperty("付方档案编码 (三方的门店或公司)")
    private String payArchiveCode;

    @ApiModelProperty("付方档案名称")
    private String payArchiveName;

    @ApiModelProperty("付方银行")
    private String payBank;

    @ApiModelProperty(value = "付款方账户号")
    private String paymentAccountNo;

    @ApiModelProperty(value = "付款方账户名称")
    private String paymentAccountName;

    @ApiModelProperty(value = "收款方账户号")
    private String payeeAccountNo;

    @ApiModelProperty(value = "收款方账户名称")
    private String payeeAccountName;

    @ApiModelProperty("收方档案编码 (三方的门店或公司)")
    private String payeeArchiveCode;

    @ApiModelProperty("收方档案名称")
    private String payeeArchiveName;

    @ApiModelProperty("收方银行")
    private String payeeBank;

    @ApiModelProperty("收支净额")
    private BigDecimal incomeAmount;

    @ApiModelProperty("交易金额")
    private BigDecimal amount;

    @ApiModelProperty("手续费")
    private BigDecimal fee;

    @ApiModelProperty("附言")
    private String postscript;

    @ApiModelProperty("传帐状态(yst-fin/AP_TRANSFER_STATUS)")
    @SysCode(sys = "yst-fin", mod = "AP_TRANSFER_STATUS")
    private String transferStatus;
    private String transferStatusName;

    @ApiModelProperty(value = "拟定状态")
    @SysCode(sys = "yst-fin", mod = "DOC_PROPOSED_STATUS")
    private String proposedStatus;
    private String proposedStatusName;

}