package com.elitesland.fin.application.service.financial;

import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.financial.DirectManagementFeeBillConvert;
import com.elitesland.fin.application.convert.financial.ManagementFeeBillConvert;
import com.elitesland.fin.application.facade.dto.financial.ManagementFeeBillDTO;
import com.elitesland.fin.application.facade.param.financial.ManagementFeeBillPageParam;
import com.elitesland.fin.application.facade.vo.financial.ManagementFeeBillVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.financial.DirectManagementFeeBillDO;
import com.elitesland.fin.entity.financial.ManagementFeeBillDO;
import com.elitesland.fin.repo.financial.DirectManagementFeeBillRepo;
import com.elitesland.fin.repo.financial.DirectManagementFeeBillRepoProc;
import com.elitesland.fin.repo.financial.ManagementFeeBillRepo;
import com.elitesland.fin.repo.financial.ManagementFeeBillRepoProc;
import com.elitesland.fin.utils.tcsl.utils.TcslApiClient;
import com.elitesland.fin.utils.tcsl.vo.BillQueryParamVO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2025/10/14 14:56
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ManagementFeeBillServiceImpl implements ManagementFeeBillService {

    private final TcslApiClient tcslApiClient;
    private final ManagementFeeBillRepo managementFeeBillRepo;
    private final ManagementFeeBillRepoProc managementFeeBillRepoProc;
    private final UdcProvider udcProvider;
    private final OrgStoreRpcService orgStoreRpcService;
    private final DirectManagementFeeBillRepo directManagementFeeBillRepo;
    private final DirectManagementFeeBillRepoProc directManagementFeeBillRepoProc;

    @SysCodeProc
    @Override
    public PagingVO<ManagementFeeBillVO> pageSearch(ManagementFeeBillPageParam param) {
        return ManagementFeeBillConvert.INSTANCE.convertPage(managementFeeBillRepoProc.page(param));
    }

    @Override
    public PagingVO<ManagementFeeBillVO> directPageSearch(ManagementFeeBillPageParam param) {
        return DirectManagementFeeBillConvert.INSTANCE.convertPage(directManagementFeeBillRepoProc.page(param));
    }

    @Override
    public void syncBill(String param) {
        BillQueryParamVO paramVO = new BillQueryParamVO();
        if(StringUtils.isNotEmpty(param)){
            String[] split = param.split(";");
            if(split.length != 2){
                throw new RuntimeException("参数错误");
            }
            paramVO.setStartTime(split[0]);
            paramVO.setEndTime(split[1]);
        }

        Map<String, String> syncStatusMap = udcProvider.getValueMapByUdcCode("yst-fin", "DC_CODE_TYPE");
        List<String> dcCodeList = new ArrayList<>(syncStatusMap.keySet());
        paramVO.setDcCodeList(dcCodeList);

        Integer pageNo = 1;
        Integer pageSize = 100;

        List<ManagementFeeBillDTO> billDTOList = new ArrayList<>();
        do {
            paramVO.setPageNo(pageNo);
            paramVO.setPageSize(pageSize);
            billDTOList = tcslApiClient.queryBill(paramVO);
            if(CollectionUtils.isNotEmpty(billDTOList)){
                // 保存账单
                List<ManagementFeeBillDO> billDOList = ManagementFeeBillConvert.INSTANCE.dtoToDo(billDTOList);

                // accountNo+bussNo，如果存在记录，那么是必返的。
                List<String> bussNoList = billDOList.stream().map(ManagementFeeBillDO::getBussNo).distinct().toList();
                List<String> accountNoList = billDOList.stream().map(ManagementFeeBillDO::getAccountNo).distinct().toList();

                ManagementFeeBillPageParam pageParam = new ManagementFeeBillPageParam();
                pageParam.setAccountNoList(accountNoList);
                pageParam.setBussNoList(bussNoList);
                pageParam.setPageFlag("N");
                List<ManagementFeeBillDTO> existList = managementFeeBillRepoProc.billList(pageParam);
                List<String> keys = new ArrayList<>();
                if(CollectionUtils.isNotEmpty(existList)){
                    keys = existList.stream().map(t -> t.getAccountNo() + "-" +t.getBussNo()).toList();
                }
                log.info("已存在管理费账单：{}", keys);

                List<ManagementFeeBillDO> saveDOList = new ArrayList<>();
                List<DirectManagementFeeBillDO> directSaveDOList = new ArrayList<>();
                // 设置传帐状态，拟定状态
                List<String> finalKeys = keys;
                List<String> storeCodeList = new ArrayList<>();
                billDOList.forEach(billDO -> {
                    if(!finalKeys.contains(billDO.getAccountNo() + "-" +billDO.getBussNo())){
                        billDO.setTransferStatus(UdcEnum.AP_TRANSFER_STATUS_WAIT.getValueCode());
                        billDO.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
                        saveDOList.add(billDO);
                    }
                    if(StringUtils.isNotEmpty(billDO.getPayArchiveCode()) && !storeCodeList.contains(billDO.getPayArchiveCode())){
                        storeCodeList.add(billDO.getPayArchiveCode());
                    }
                });

                // 付方档案编码如果是直营店，在新建一张直营店管理费账单保存
                Map<String, String> storeMap = new HashMap<>();
                if(CollectionUtils.isNotEmpty(storeCodeList)){
                    OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
                    orgStoreBaseRpcParam.setStoreCodeList(storeCodeList);
                    ApiResult<List<OrgStoreBaseRpcDTO>> apiResult = orgStoreRpcService.findOrgStoreBaseByParam(orgStoreBaseRpcParam);
                    log.info("查询门店信息：{}", apiResult);
                    if(!apiResult.isSuccess()){
                        throw new RuntimeException("查询门店信息异常：" + apiResult.getErrorMsg());
                    }
                    List<OrgStoreBaseRpcDTO> data = apiResult.getData();
                    if(CollectionUtils.isEmpty(data)){
                        throw new RuntimeException("未查询到门店信息【" + String.join(",", storeCodeList) + "】");
                    }
                    storeMap = data.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, OrgStoreBaseRpcDTO::getStoreType2, (t1, t2) -> t1));
                }

                Map<String, String> finalStoreMap = storeMap;
                billDOList.forEach(billDO -> {
                    if(StringUtils.isNotEmpty(billDO.getPayArchiveCode()) && finalStoreMap.containsKey(billDO.getPayArchiveCode())
                        && "DIRECTSALE2".equals(finalStoreMap.get(billDO.getPayArchiveCode()))){ // 直营
                        directSaveDOList.add(DirectManagementFeeBillConvert.INSTANCE.billToDirectBill(billDO));
                    }
                });

                if(CollectionUtils.isNotEmpty(saveDOList)){
                    managementFeeBillRepo.saveAll(saveDOList);
                }

                if(CollectionUtils.isNotEmpty(directSaveDOList)){
                    directManagementFeeBillRepo.saveAll(directSaveDOList);
                }
            }
            pageNo++;
        } while (CollectionUtils.isNotEmpty(billDTOList));
    }
}
