package com.elitesland.fin.entity.financial;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhiyu.he
 * @date 2025/10/14 10:29
 */
@Entity
@Table(name = "direct_management_fee_bill")
@org.hibernate.annotations.Table(appliesTo = "direct_management_fee_bill", comment = "直营店管理费账单")
@Data
@Where(clause = "delete_flag = 0")
@ApiModel(value = "direct_management_fee_bill", description = "直营店管理费账单")
public class DirectManagementFeeBillDO extends BaseModel implements Serializable {

    @Column(name = "account_no")
    @ApiModelProperty("账户号")
    private String accountNo;

    @Column(name = "account_time")
    @ApiModelProperty("记账日期 (格式: yyyy-MM-dd HH:mm:ss)")
    private String accountTime;

    @Column(name = "dc_type")
    @ApiModelProperty("收支类型")
    private String dcType;

    @Column(name = "dc_code")
    @ApiModelProperty("收支编码")
    private String dcCode;

    @Column(name = "dc_name")
    @ApiModelProperty("收支名称")
    private String dcName;

    @Column(name = "account_type")
    @ApiModelProperty("账户类型")
    private String accountType;

    @Column(name = "buss_no")
    @ApiModelProperty("平台流水号")
    private String bussNo;

    @Column(name = "sl_buss_no")
    @ApiModelProperty("云资金流水号")
    private String slBussNo;

    @Column(name = "out_buss_no")
    @ApiModelProperty("外部业务单号")
    private String outBussNo;

    @Column(name = "pay_archive_code")
    @ApiModelProperty("付方档案编码 (三方的门店或公司)")
    private String payArchiveCode;

    @Column(name = "pay_archive_name")
    @ApiModelProperty("付方档案名称")
    private String payArchiveName;

    @Column(name = "pay_bank")
    @ApiModelProperty("付方银行")
    private String payBank;

    @Column(name = "payment_account_no")
    @ApiModelProperty(value = "付款方账户号")
    private String paymentAccountNo;

    @Column(name = "payment_account_name")
    @ApiModelProperty(value = "付款方账户名称")
    private String paymentAccountName;

    @Column(name = "payee_account_no")
    @ApiModelProperty(value = "收款方账户号")
    private String payeeAccountNo;

    @Column(name = "payee_account_name")
    @ApiModelProperty(value = "收款方账户名称")
    private String payeeAccountName;

    @Column(name = "payee_archive_code")
    @ApiModelProperty("收方档案编码 (三方的门店或公司)")
    private String payeeArchiveCode;

    @Column(name = "payee_archive_name")
    @ApiModelProperty("收方档案名称")
    private String payeeArchiveName;

    @Column(name = "payee_bank")
    @ApiModelProperty("收方银行")
    private String payeeBank;

    @Column(name = "income_amount")
    @ApiModelProperty("收支净额")
    private BigDecimal incomeAmount;

    @Column(name = "amount")
    @ApiModelProperty("交易金额")
    private BigDecimal amount;

    @Column(name = "fee")
    @ApiModelProperty("手续费")
    private BigDecimal fee;

    @Column(name = "postscript")
    @ApiModelProperty("附言")
    private String postscript;

    @Column
    @ApiModelProperty("传账状态")
    private String transferStatus;

    @Column
    @ApiModelProperty("拟定状态")
    private String proposedStatus;

}
