package com.elitesland.fin.utils.tcsl.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 拉卡拉支付配置属性类
 * 用于读取application.yml中lakala前缀的配置项
 */
@Data
@Component
@ConfigurationProperties(prefix = "lakala")
public class LakalaProperties {

    public static final String CONFIG_PREFIX = "lakala";

    /**
     * 平台id
     */
    private String host;

    /**
     * 应用密钥，用于签名验证
     */
    private String appSecret;

    /**
     * 应用key，用于身份认证
     */
    private String appKey;

    /**
     * 集团ID，在开放平台进行开通时填写的G号
     */
    private String groupID;

    /**
     * 品牌编号 固定值:由天财分配
     */
    private Long brandId;

    /**
     * 账单查询方法
     */
    private String billQuery;

    /**
     * 租户编码
     */
    private String tenantCode;
}
