package com.elitesland.fin.utils.tcsl.utils;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SignUtil {


    static Logger log = LoggerFactory.getLogger(SignUtil.class);

    private SignUtil() {
    }

    public static String getSig(String appSecret, String baseUrl) {
        try {
            return signHS256(appSecret, baseUrl);
        } catch (Exception e) {
            log.warn("getSign Exception ", e);
        }

        return StringUtils.EMPTY;
    }

    public static String getSigBaseURL(String host, String methedName, Map<String, String> params) {
        try {
            String sortedParamStr = getSortedParamStr(params);
            return host + methedName + "?" + sortedParamStr;

        } catch (UnsupportedEncodingException e) {
            log.warn("getSign UnsupportedEncodingException ", e);
        }

        return StringUtils.EMPTY;
    }

    /**
     * 构造自然排序请求参数
     *
     * @param params 请求
     * @return 字符串
     */
    public static String getSortedParamStr(Map<String, String> params) throws UnsupportedEncodingException {
        Set<String> sortedParams = new TreeSet<>(params.keySet());
        StringBuilder sortedParamStr = new StringBuilder();
        for (String key : sortedParams) {
            String value = params.get(key);
            // 排除sign
            if (null != value && !"".equals(value) && !"sign".equalsIgnoreCase(key)) {
                sortedParamStr.append(key + "=" + URLEncoder.encode(value, "UTF-8") + "&");
            }
        }
        return sortedParamStr.substring(0, sortedParamStr.length() - 1);
    }


    /**
     * 进行 hs256签名
     *
     * @param appSecret         应用秘钥，创建应用审核通过后生成，用于加密使用，不在交互中传播
     * @param baseUrl           生成sig的完整url
     * @return 签名的hex编码
     */
    public static String signHS256(String appSecret, String baseUrl) {
        try {
            Mac hs256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(appSecret.getBytes("UTF-8"), "HmacSHA256");
            hs256.init(secretKey);
            byte[] bytes = hs256.doFinal(baseUrl.getBytes("UTF-8"));

            return toHex(bytes);
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("不支持HmacSHA256算法", e);
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("不支持utf8编码", e);
        } catch (Exception e) {
            throw new RuntimeException("hs256签名失败", e);
        }
    }

    public static String toHex(byte[] bytes) {
        StringBuffer hexstr = new StringBuffer();
        for (int i = 0; i < bytes.length; i++) {
            String b = Integer.toHexString(bytes[i] & 0xFF);
            if (b.length() < 2) {
                hexstr.append(0);
            }
            hexstr.append(b);
        }

        return hexstr.toString();
    }

    /**
     * 构造自然排序请求参数
     *
     * @param params 请求
     * @return 字符串
     */
    public static String getSortedParam(Map<String, Object> params) throws UnsupportedEncodingException {
        Set<String> sortedParams = new TreeSet<>(params.keySet());
        StringBuilder sortedParamStr = new StringBuilder();
        for (String key : sortedParams) {
            String value = String.valueOf(params.get(key));
            // 排除sign
            if (null != value && !"".equals(value) && !"sign".equalsIgnoreCase(key)) {
                sortedParamStr.append(key + "=" + URLEncoder.encode(value, "UTF-8") + "&");
            }
        }
        return sortedParamStr.substring(0, sortedParamStr.length() - 1);
    }

    public static String getSignHmacSHA256(Map<String, Object> params, String secret) {
        String sortStr = null;
        try {
            sortStr = getSortedParam(params);
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("参数排序失败", e);
        }
        return signHS256(secret, sortStr);
    }

    public static void main(String[] args) {
        //开放平台业务接口，目前只支持HTTP POST一种请求方式
        //指定Body Content-Type为：application/x-www-form-urlencoded
        //Post请求时，所有参数均通过表单传递，请勿将请求参数放到Query参数中。
//        String appSecret = "DFwTESDKTOV58V0JJersmY02MhFDBscd";//你的appSecret，注意替换
        String appSecret = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQClM6wR8yM56vQBPdumTO0Tac4oBaKYvnsOFOiAG/rOiMhPXZ790KEoURY3afPg3ALYrxTQQBlISKaC+7Nrd59QLKrjYYedu2mC88ljGl2KgrIHaIuSaFHeS2zrur9GfxgzDUrOhQ7wLnLTY3mzCT0nX4jTATEgfD6Juo+TzHBPcwIDAQAB";
        Map<String, Object> param = new HashMap();
        //下方的参数为每次调用api需要的参数
        param.put("productCode", "1649290269055750179");//fc77a42e71f1a1272322d0b380738d5b60ab2fbac797397e0fefbfff3e996bac
        param.put("terminalId", "4444");//ad02ea305247263df7440b50403b89bd326d10653d702324f2a659afaf2442fd
//        param.put("biz", "{\"omCorpCode\":\"G292730\",\"name\":\"张三\",\"offset\":1,\"limit\":10}");
//        param.put("version", "1");
//        param.put("charset", "UTF-8");
        String sign =  getSignHmacSHA256(param,appSecret);
        System.out.println(sign);
        String sign1 =  getSignHmacSHA256(param,appSecret);
        System.out.println(sign1);
//        String host = "http://open-test.tcsl.com.cn/api/";
//        String methedName = "fengxing/v1/user/queryUserList";
//        System.out.println("请求URL："+ URLDecoder.decode(SigUtil.getSigBaseURL(host, methedName, param)));
//        String sign = SigUtil.getSig(appSecret, SigUtil.getSigBaseURL(host, methedName, param));
//        System.out.println("签名:"+sign);
//        System.out.println("开放平台验证签名URL："+URLDecoder.decode(SigUtil.getSigBaseURL(host, methedName, param))+"&sig="+sign);
    }
}
