/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.financial;

import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.financial.DirectManagementFeeBillConvert;
import com.elitesland.fin.application.convert.financial.ManagementFeeBillConvert;
import com.elitesland.fin.application.facade.dto.financial.ManagementFeeBillDTO;
import com.elitesland.fin.application.facade.param.financial.ManagementFeeBillPageParam;
import com.elitesland.fin.application.facade.vo.financial.ManagementFeeBillVO;
import com.elitesland.fin.application.service.financial.ManagementFeeBillService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.financial.ManagementFeeBillDO;
import com.elitesland.fin.repo.financial.DirectManagementFeeBillRepo;
import com.elitesland.fin.repo.financial.DirectManagementFeeBillRepoProc;
import com.elitesland.fin.repo.financial.ManagementFeeBillRepo;
import com.elitesland.fin.repo.financial.ManagementFeeBillRepoProc;
import com.elitesland.fin.utils.tcsl.utils.TcslApiClient;
import com.elitesland.fin.utils.tcsl.vo.BillQueryParamVO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ManagementFeeBillServiceImpl
implements ManagementFeeBillService {
    private static final Logger log = LoggerFactory.getLogger(ManagementFeeBillServiceImpl.class);
    private final TcslApiClient tcslApiClient;
    private final ManagementFeeBillRepo managementFeeBillRepo;
    private final ManagementFeeBillRepoProc managementFeeBillRepoProc;
    private final UdcProvider udcProvider;
    private final OrgStoreRpcService orgStoreRpcService;
    private final DirectManagementFeeBillRepo directManagementFeeBillRepo;
    private final DirectManagementFeeBillRepoProc directManagementFeeBillRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ManagementFeeBillVO> pageSearch(ManagementFeeBillPageParam param) {
        return ManagementFeeBillConvert.INSTANCE.convertPage(this.managementFeeBillRepoProc.page(param));
    }

    @Override
    public PagingVO<ManagementFeeBillVO> directPageSearch(ManagementFeeBillPageParam param) {
        return DirectManagementFeeBillConvert.INSTANCE.convertPage(this.directManagementFeeBillRepoProc.page(param));
    }

    @Override
    public void syncBill(String param) {
        BillQueryParamVO paramVO = new BillQueryParamVO();
        if (StringUtils.isNotEmpty((CharSequence)param)) {
            String[] split = param.split(";");
            if (split.length != 2) {
                throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
            }
            paramVO.setStartTime(split[0]);
            paramVO.setEndTime(split[1]);
        }
        Map syncStatusMap = this.udcProvider.getValueMapByUdcCode("yst-fin", "DC_CODE_TYPE");
        ArrayList<String> dcCodeList = new ArrayList<String>(syncStatusMap.keySet());
        paramVO.setDcCodeList(dcCodeList);
        Integer pageNo = 1;
        Integer pageSize = 100;
        ArrayList<ManagementFeeBillDTO> billDTOList = new ArrayList();
        do {
            paramVO.setPageNo(pageNo);
            paramVO.setPageSize(pageSize);
            billDTOList = this.tcslApiClient.queryBill(paramVO);
            if (CollectionUtils.isNotEmpty(billDTOList)) {
                List<ManagementFeeBillDO> billDOList = ManagementFeeBillConvert.INSTANCE.dtoToDo(billDTOList);
                List<String> bussNoList = billDOList.stream().map(ManagementFeeBillDO::getBussNo).distinct().toList();
                List<String> accountNoList = billDOList.stream().map(ManagementFeeBillDO::getAccountNo).distinct().toList();
                ManagementFeeBillPageParam pageParam = new ManagementFeeBillPageParam();
                pageParam.setAccountNoList(accountNoList);
                pageParam.setBussNoList(bussNoList);
                pageParam.setPageFlag("N");
                List<ManagementFeeBillDTO> existList = this.managementFeeBillRepoProc.billList(pageParam);
                List<Object> keys = new ArrayList();
                if (CollectionUtils.isNotEmpty(existList)) {
                    keys = existList.stream().map(t -> t.getAccountNo() + "-" + t.getBussNo()).toList();
                }
                log.info("\u5df2\u5b58\u5728\u7ba1\u7406\u8d39\u8d26\u5355\uff1a{}", keys);
                ArrayList saveDOList = new ArrayList();
                ArrayList directSaveDOList = new ArrayList();
                List<Object> finalKeys = keys;
                ArrayList storeCodeList = new ArrayList();
                billDOList.forEach(billDO -> {
                    if (!finalKeys.contains(billDO.getAccountNo() + "-" + billDO.getBussNo())) {
                        billDO.setTransferStatus(UdcEnum.AP_TRANSFER_STATUS_WAIT.getValueCode());
                        billDO.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
                        saveDOList.add(billDO);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)billDO.getPayArchiveCode()) && !storeCodeList.contains(billDO.getPayArchiveCode())) {
                        storeCodeList.add(billDO.getPayArchiveCode());
                    }
                });
                Map<Object, Object> storeMap = new HashMap();
                if (CollectionUtils.isNotEmpty(storeCodeList)) {
                    OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
                    orgStoreBaseRpcParam.setStoreCodeList(storeCodeList);
                    ApiResult apiResult = this.orgStoreRpcService.findOrgStoreBaseByParam(orgStoreBaseRpcParam);
                    log.info("\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\uff1a{}", (Object)apiResult);
                    if (!apiResult.isSuccess()) {
                        throw new RuntimeException("\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u5f02\u5e38\uff1a" + apiResult.getErrorMsg());
                    }
                    List data = (List)apiResult.getData();
                    if (CollectionUtils.isEmpty((Collection)data)) {
                        throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u95e8\u5e97\u4fe1\u606f\u3010" + String.join((CharSequence)",", storeCodeList) + "\u3011");
                    }
                    storeMap = data.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, OrgStoreBaseRpcDTO::getStoreType2, (t1, t2) -> t1));
                }
                HashMap finalStoreMap = storeMap;
                billDOList.forEach(billDO -> {
                    if (StringUtils.isNotEmpty((CharSequence)billDO.getPayArchiveCode()) && finalStoreMap.containsKey(billDO.getPayArchiveCode()) && "DIRECTSALE2".equals(finalStoreMap.get(billDO.getPayArchiveCode()))) {
                        directSaveDOList.add(DirectManagementFeeBillConvert.INSTANCE.billToDirectBill((ManagementFeeBillDO)billDO));
                    }
                });
                if (CollectionUtils.isNotEmpty(saveDOList)) {
                    this.managementFeeBillRepo.saveAll(saveDOList);
                }
                if (CollectionUtils.isNotEmpty(directSaveDOList)) {
                    this.directManagementFeeBillRepo.saveAll(directSaveDOList);
                }
            }
            Integer n = pageNo;
            pageNo = pageNo + 1;
        } while (CollectionUtils.isNotEmpty(billDTOList));
    }

    public ManagementFeeBillServiceImpl(TcslApiClient tcslApiClient, ManagementFeeBillRepo managementFeeBillRepo, ManagementFeeBillRepoProc managementFeeBillRepoProc, UdcProvider udcProvider, OrgStoreRpcService orgStoreRpcService, DirectManagementFeeBillRepo directManagementFeeBillRepo, DirectManagementFeeBillRepoProc directManagementFeeBillRepoProc) {
        this.tcslApiClient = tcslApiClient;
        this.managementFeeBillRepo = managementFeeBillRepo;
        this.managementFeeBillRepoProc = managementFeeBillRepoProc;
        this.udcProvider = udcProvider;
        this.orgStoreRpcService = orgStoreRpcService;
        this.directManagementFeeBillRepo = directManagementFeeBillRepo;
        this.directManagementFeeBillRepoProc = directManagementFeeBillRepoProc;
    }
}

