package com.elitesland.fin.application.facade.param.flow;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2023/3/6 11:53
 */
@Data
public class SaveFlowParam implements Serializable {
    private static final long serialVersionUID = 6866132173811687670L;
    @ApiModelProperty("调整类型")
    private  String  adjType;
    @ApiModelProperty("账户类型")
    private  String accType;
    @ApiModelProperty("账户编码")
    private  String accCode;
    @ApiModelProperty("账户名称")
    private  String accName;
    @ApiModelProperty("金额")
    private BigDecimal totalAmt;
    @ApiModelProperty("来源单号")
    private  String docNo;
    @ApiModelProperty("来源id")
    private Long sourceId;
    @ApiModelProperty("场景")
    private  String scene;
    @ApiModelProperty("日期")
    private LocalDateTime time;
    @ApiModelProperty("调整原因")
    private String adjReason;
    @ApiModelProperty("单据类型")
    private String  type;
    @ApiModelProperty("从账户类型")
    private  String accTypeFrom;
    @ApiModelProperty("账户编码")
    private  String accCodeFrom;
    @ApiModelProperty("账户名称")
    private  String accNameFrom;
    @ApiModelProperty("至账户类型")
    private  String accTypeTo;
    @ApiModelProperty("账户编码")
    private  String accCodeTo;
    @ApiModelProperty("账户名称")
    private  String accNameTo;
    @ApiModelProperty("账户规则编码")
    private String ruleCode;
    @ApiModelProperty("账户规则名称")
    private String ruleName;
    @ApiModelProperty(value = "执行序列")
    private Integer priorityNo;
}
