package com.elitesland.fin.application.facade.vo.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "账套")
public class FinAbstractVO extends BaseModelVO {

    @ApiModelProperty("编码")
    private String code;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("事件表单ID")
    private Long eventId;

    @ApiModelProperty("事件表单名称")
    private String eventName;

    @ApiModelProperty("状态（0-草稿，1-启用，2-停用）")
    @SysCode(sys = "yst-fin",mod = "ABSTRACT_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty("明细")
    private List<FinAbstractDetailVO> detailList;
}
