package com.elitesland.fin.application.web.financial;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.financial.ManagementFeeBillPageParam;
import com.elitesland.fin.application.facade.vo.financial.ManagementFeeBillVO;
import com.elitesland.fin.application.service.financial.ManagementFeeBillService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;


/**
 * @author Karl.wang
 * @version V1.0
 * @Package com.elitesland.fin.application.web.aporder
 * @date 2022/3/16 16:08
 */
@RestController
@RequestMapping("/fin/managementFeeBill")
@RequiredArgsConstructor
@Api(value = "管理费账单", tags = {"管理费账单"})
public class ManagementFeeBillController {

    private final ManagementFeeBillService managementFeeBillService;

    @PostMapping("/page")
    @ApiOperation("账单分页查询")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "账单分页查询",
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<ManagementFeeBillVO>> page(@RequestBody ManagementFeeBillPageParam param) {
        return ApiResult.ok(managementFeeBillService.pageSearch(param));
    }

    @PostMapping("/direct/page")
    @ApiOperation("直营账单分页查询")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "账单分页查询",
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<ManagementFeeBillVO>> directPage(@RequestBody ManagementFeeBillPageParam param) {
        return ApiResult.ok(managementFeeBillService.directPageSearch(param));
    }

    @GetMapping("/test")
    @ApiOperation("job测试")
    public ApiResult test() {
        managementFeeBillService.syncBill("");
        return ApiResult.ok();
    }

}
