package com.elitesland.fin.application.web.rectype;

import com.elitesland.fin.application.facade.param.rectype.RecTypeOuParam;
import com.elitesland.fin.application.facade.param.rectype.RecTypeSaveParam;
import com.elitesland.fin.application.facade.vo.rectype.RecTypeOuVO;
import com.elitesland.fin.application.facade.vo.rectype.RecTypeVO;
import com.elitesland.fin.application.service.rectype.RecTypeOuService;
import com.elitesland.fin.application.service.rectype.RecTypeService;
import com.elitesland.fin.domain.param.rectype.RecTypeOuPageParam;
import com.elitesland.fin.domain.param.rectype.RecTypePageParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/11 13:49
 */
@RestController
@RequestMapping("/fin/recType")
@RequiredArgsConstructor
@Api(value = "收款单类型定义", tags = {"收款单类型定义"})
public class RecTypeController {

    private final RecTypeService recTypeService;

    private final RecTypeOuService recTypeOuService;

    @PostMapping("page")
    @ApiOperation("分页查询收款单类型定义")
    public ApiResult<PagingVO<RecTypeVO>> page(@RequestBody RecTypePageParam param) {
        return recTypeService.page(param);
    }

    @GetMapping("findAll")
    @ApiOperation("下拉框-查询所有收款单类型定义")
    public ApiResult<List<RecTypeVO>> findAll() {
        return recTypeService.findAll();
    }

    @DeleteMapping("delete")
    @ApiOperation("删除收款单类型定义")
    public ApiResult<List<Long>> delete(@RequestBody List<Long> ids) {
        return recTypeService.delete(ids);
    }

    @PutMapping("makeDefault/{id}")
    @ApiOperation("默认收款单类型定义")
    public ApiResult<Long> makeDefault(@PathVariable("id") Long id) {
        return recTypeService.makeDefault(id);
    }

    @PutMapping("enable")
    @ApiOperation("启用定义数据")
    public ApiResult<List<Long>> enable(@RequestBody List<Long> ids) {
        return recTypeService.enable(ids);
    }

    @PutMapping("stop")
    @ApiOperation("停用定义数据")
    public ApiResult<List<Long>> stop(@RequestBody List<Long> ids) {
        return recTypeService.stopEnable(ids);
    }

    @PostMapping("save")
    @ApiOperation("新增/修改收款单类型定义")
    public ApiResult<Long> save(@RequestBody RecTypeSaveParam param) {
        return recTypeService.save(param);
    }

    @PostMapping("addOu")
    @ApiOperation("分配公司")
    public ApiResult<List<Long>> addOu(@RequestBody RecTypeOuParam param) {
        return recTypeOuService.addOu(param);
    }

    @PostMapping("cancelOu")
    @ApiOperation("取消分配公司")
    public ApiResult<List<Long>> cancelOu(@RequestBody List<Long> ids) {
        return recTypeOuService.cancelOu(ids);
    }

    @GetMapping("details/{id}")
    @ApiOperation("获取详情")
    public ApiResult<RecTypeVO> details(@PathVariable("id") Long id) {
        return recTypeService.queryById(id);
    }

    @PostMapping("listOu")
    @ApiOperation("根据收款单类型定义ID查询分配公司")
    public ApiResult<PagingVO<RecTypeOuVO>> listOu(@RequestBody RecTypeOuPageParam param) {
        return ApiResult.ok(recTypeOuService.page(param));
    }
}
