package com.elitesland.fin.repo.financial;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.financial.ManagementFeeBillDTO;
import com.elitesland.fin.application.facade.param.financial.ManagementFeeBillPageParam;
import com.elitesland.fin.entity.financial.QDirectManagementFeeBillDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/17 14:30
 */
@Component
@RequiredArgsConstructor
public class DirectManagementFeeBillRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QDirectManagementFeeBillDO directManagementFeeBillDO = QDirectManagementFeeBillDO.directManagementFeeBillDO;

    public PagingVO<ManagementFeeBillDTO> page(ManagementFeeBillPageParam param) {
        List<Predicate> where = where(param);
        JPAQuery<ManagementFeeBillDTO> query = select(ManagementFeeBillDTO.class).where(ExpressionUtils.allOf(where));
        param.setPaging(query);
        param.fillOrders(query, directManagementFeeBillDO);
        return PagingVO.<ManagementFeeBillDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public List<ManagementFeeBillDTO> billList(ManagementFeeBillPageParam param) {
        List<Predicate> where = where(param);
        JPAQuery<ManagementFeeBillDTO> query = select(ManagementFeeBillDTO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private List<Predicate> where(ManagementFeeBillPageParam param) {
        List<Predicate> predicates = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(param.getIdList())) {
            predicates.add(directManagementFeeBillDO.id.in(param.getIdList()));
        }
        if (StringUtils.isNotEmpty(param.getAccountNo())) {
            predicates.add(directManagementFeeBillDO.accountNo.eq(param.getAccountNo()));
        }
        if (CollectionUtils.isNotEmpty(param.getAccountNoList())) {
            predicates.add(directManagementFeeBillDO.accountNo.in(param.getAccountNoList()));
        }
        if (StringUtils.isNotEmpty(param.getAccountTime())) {
            predicates.add(directManagementFeeBillDO.accountTime.gt(param.getAccountTime()));
        }
        if (StringUtils.isNotEmpty(param.getAccountTimeStart())) {
            predicates.add(directManagementFeeBillDO.accountTime.goe(param.getAccountTimeStart()));
        }
        if (StringUtils.isNotEmpty(param.getAccountTimeEnd())) {
            predicates.add(directManagementFeeBillDO.accountTime.loe(param.getAccountTimeEnd()));
        }
        if (StringUtils.isNotEmpty(param.getDcType())) {
            predicates.add(directManagementFeeBillDO.dcType.eq(param.getDcType()));
        }
        if (StringUtils.isNotEmpty(param.getDcCode())) {
            predicates.add(directManagementFeeBillDO.dcCode.eq(param.getDcCode()));
        }
        if (StringUtils.isNotEmpty(param.getDcName())) {
            predicates.add(directManagementFeeBillDO.dcName.eq(param.getDcName()));
        }
        if (StringUtils.isNotEmpty(param.getAccountType())) {
            predicates.add(directManagementFeeBillDO.accountType.eq(param.getAccountType()));
        }
        if (StringUtils.isNotEmpty(param.getBussNo())) {
            predicates.add(directManagementFeeBillDO.bussNo.eq(param.getBussNo()));
        }
        if (CollectionUtils.isNotEmpty(param.getBussNoList())) {
            predicates.add(directManagementFeeBillDO.bussNo.in(param.getBussNoList()));
        }
        if (StringUtils.isNotEmpty(param.getSlBussNo())) {
            predicates.add(directManagementFeeBillDO.slBussNo.eq(param.getSlBussNo()));
        }
        if (StringUtils.isNotEmpty(param.getOutBussNo())) {
            predicates.add(directManagementFeeBillDO.outBussNo.eq(param.getOutBussNo()));
        }
        if (StringUtils.isNotEmpty(param.getPaymentAccountNo())) {
            predicates.add(directManagementFeeBillDO.paymentAccountNo.eq(param.getPaymentAccountNo()));
        }
        if (StringUtils.isNotEmpty(param.getPayeeAccountNo())) {
            predicates.add(directManagementFeeBillDO.payeeAccountNo.eq(param.getPayeeAccountNo()));
        }
        if (StringUtils.isNotEmpty(param.getProposedStatus())) {
            predicates.add(directManagementFeeBillDO.proposedStatus.eq(param.getProposedStatus()));
        }
        if (StringUtils.isNotEmpty(param.getTransferStatus())) {
            predicates.add(directManagementFeeBillDO.transferStatus.eq(param.getTransferStatus()));
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                directManagementFeeBillDO.id,
                directManagementFeeBillDO.modifyTime,
                directManagementFeeBillDO.modifyUserId,
                directManagementFeeBillDO.updater,
                directManagementFeeBillDO.createTime,
                directManagementFeeBillDO.createUserId,
                directManagementFeeBillDO.remark,
                directManagementFeeBillDO.deleteFlag,
                directManagementFeeBillDO.tenantId,
                directManagementFeeBillDO.tenantOrgId,
                directManagementFeeBillDO.secBuId,
                directManagementFeeBillDO.secOuId,
                directManagementFeeBillDO.secUserId,
                directManagementFeeBillDO.belongOrgId,
                directManagementFeeBillDO.auditDataVersion,
                directManagementFeeBillDO.accountNo,
                directManagementFeeBillDO.accountTime,
                directManagementFeeBillDO.dcType,
                directManagementFeeBillDO.dcCode,
                directManagementFeeBillDO.dcName,
                directManagementFeeBillDO.accountType,
                directManagementFeeBillDO.bussNo,
                directManagementFeeBillDO.slBussNo,
                directManagementFeeBillDO.outBussNo,
                directManagementFeeBillDO.payArchiveCode,
                directManagementFeeBillDO.payArchiveName,
                directManagementFeeBillDO.payBank,
                directManagementFeeBillDO.paymentAccountNo,
                directManagementFeeBillDO.paymentAccountName,
                directManagementFeeBillDO.payeeAccountNo,
                directManagementFeeBillDO.payeeAccountName,
                directManagementFeeBillDO.payeeArchiveCode,
                directManagementFeeBillDO.payeeArchiveName,
                directManagementFeeBillDO.payeeBank,
                directManagementFeeBillDO.incomeAmount,
                directManagementFeeBillDO.amount,
                directManagementFeeBillDO.fee,
                directManagementFeeBillDO.postscript,
                directManagementFeeBillDO.remark,
                directManagementFeeBillDO.proposedStatus,
                directManagementFeeBillDO.transferStatus
        )).from(directManagementFeeBillDO);
    }

}
