package com.elitesland.fin.utils.tcsl.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel("管理费账单")
public class BillQueryParamVO implements Serializable {
    private static final long serialVersionUID = 6074350548106028859L;

    @ApiModelProperty("品牌编号(固定值:由天财分配) 必填")
    private Long brandId;

    @ApiModelProperty("账户编号 非必填")
    private String accountNo;

    @ApiModelProperty("收支编码 非必填")
    private List<String> dcCodeList;

    @ApiModelProperty("开始时间 必填 格式：yyyy-MM-dd HH:mm:ss")
    private String startTime;

    @ApiModelProperty("结束时间 必填 格式：yyyy-MM-dd HH:mm:ss")
    private String endTime;

    @ApiModelProperty("页码 非必填 默认1")
    private Integer pageNo;

    @ApiModelProperty("每页条数 非必填 默认10")
    private Integer pageSize;

}
