/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.bdata.cache;

import com.elitesland.yst.bdata.cache.BDataCacheHandler;
import com.elitesland.yst.bdata.cache.BDataCacheProperties;
import com.elitesland.yst.bdata.common.SpringContextHelper;
import com.elitesland.yst.bdata.global.db.DataSourceConfiguration;
import com.elitesland.yst.bdata.task.RefresCacheCompent;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@AutoConfigureAfter(value={DataSourceConfiguration.class})
@EnableConfigurationProperties(value={BDataCacheProperties.class})
@ConditionalOnProperty(value={"yst.bizdata.cache.enabled"}, matchIfMissing=false)
public class BDataCacheAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BDataCacheAutoConfiguration.class);
    @Autowired
    private BDataCacheProperties properties;

    @ConditionalOnClass(value={DataSource.class})
    @Bean(value={"bdataCacheHandler"})
    public BDataCacheHandler bDataCacheInfo(DataSource dataSource, SpringContextHelper springContextHelper) {
        log.info("\u4e1a\u52a1\u6570\u636e\u52a0\u8f7d\u5f00\u59cb");
        BDataCacheHandler handler = new BDataCacheHandler(dataSource, this.properties, springContextHelper);
        return handler;
    }

    @DependsOn(value={"bdataCacheHandler"})
    @Bean
    public RefresCacheCompent doInitTask(@Qualifier(value="bdataCacheHandler") BDataCacheHandler hander) {
        int refreshTime = this.properties.getRefreshTime();
        RefresCacheCompent compent = new RefresCacheCompent(hander, refreshTime);
        return compent;
    }

    @Bean
    public SpringContextHelper springContextHelper() {
        SpringContextHelper helper = new SpringContextHelper();
        return helper;
    }
}

