/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.bdata.cache;

import com.elitesland.yst.bdata.cache.BDataCacheProperties;
import com.elitesland.yst.bdata.cache.BDataPool;
import com.elitesland.yst.bdata.common.SpringContextHelper;
import com.elitesland.yst.bdata.util.DateUtils;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BDataCacheHandler {
    private static final Logger log = LoggerFactory.getLogger(BDataCacheHandler.class);
    private DataSource dataSource;
    private BDataCacheProperties properties;

    public BDataCacheHandler() {
    }

    public BDataCacheHandler(DataSource dataSource, BDataCacheProperties properties, SpringContextHelper springContextHelper) {
        this.dataSource = dataSource;
        this.properties = properties;
    }

    @PostConstruct
    public void processOn() {
        this.doHandler();
        this.println();
    }

    private void println() {
        for (String key : BDataPool.getCodeMap().keySet()) {
            Map<String, String> val = BDataPool.getCodeMap().get(key);
            Iterator<String> it2 = val.keySet().iterator();
            log.info("^^^^type=" + key + ",size:" + val.size());
            while (it2.hasNext()) {
                String key2 = it2.next();
                String val2 = val.get(key2);
                log.debug("key=" + key2 + ",val=" + val2);
            }
        }
    }

    public void doHandler() {
        List<BDataCacheProperties.DataInfo> list = this.properties.getDataInfo();
        if (StringUtils.isEmpty(list)) {
            log.info("\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u7f13\u5b58\u6570\u636e\u7684\u914d\u7f6e\u6570\u636e");
        }
        for (BDataCacheProperties.DataInfo inf : list) {
            Map<Object, Object> result = new HashMap();
            result = this.dDataCache(inf);
            if (result == null) continue;
            BDataPool.setCodeMap(result);
        }
        log.info("\u7f13\u5b58\u5237\u65b0\u5b8c\u6210,\u5237\u65b0\u65f6\u95f4:{}", (Object)DateUtils.getCurTM());
    }

    public static void main(String[] args) {
        BDataCacheHandler d = new BDataCacheHandler();
        String type = "1";
        String sql = "select id   ,   REAL_NAME   from      t_sys_user";
        d.getDefaultNamespace(type, sql);
    }

    private Map<String, Map<String, String>> dDataCache(BDataCacheProperties.DataInfo inf) {
        String dataSourceName = inf.getDataSourceName();
        Map<String, Map<String, String>> result = null;
        if (StringUtils.isEmpty((Object)inf.getNamespace())) {
            return null;
        }
        String nameSpace = inf.getNamespace();
        if ("1".equals(inf.getType())) {
            result = this.singleData(dataSourceName, nameSpace, inf.getSql());
        } else if ("2".equals(inf.getType())) {
            result = this.doubleData(dataSourceName, nameSpace, inf.getSql());
        }
        return result;
    }

    private String getDefaultNamespace(String type, String sql) {
        String[] array = sql.toUpperCase().split("FROM");
        if (array.length != 2) {
            return null;
        }
        List<String> r1 = this.removeNull(array[0].split(" "));
        List<String> r2 = this.removeNull(array[1].split(" "));
        if (!"SELECT".equals(r1.get(0))) {
            return null;
        }
        String result = r2.get(0);
        return result;
    }

    private List<String> removeNull(String[] arr) {
        ArrayList<String> result = new ArrayList<String>();
        for (String a : arr) {
            if (StringUtils.isEmpty((Object)(a = a.replaceAll(" ", "")))) continue;
            result.add(a);
        }
        return result;
    }

    private Map<String, Map<String, String>> singleData(String dataSourceName, final String namespace, final String sql) {
        return this.execute(dataSourceName, new JdbcCallback<Map<String, Map<String, String>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, Map<String, String>> doInConnection(Connection c) {
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    ps = c.prepareStatement(sql);
                    rs = ps.executeQuery();
                    HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
                    HashMap<String, String> val = new HashMap<String, String>();
                    while (rs.next()) {
                        val.put(rs.getString(1), rs.getString(2));
                    }
                    result.put(namespace, val);
                    HashMap<String, Map<String, String>> hashMap = result;
                    return hashMap;
                }
                catch (SQLException e) {
                    log.error("SQLException178", (Throwable)e);
                    Map<String, Map<String, String>> map = null;
                    return map;
                }
                finally {
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException e) {
                        log.error("SQLException186", (Throwable)e);
                    }
                }
            }
        });
    }

    private Map<String, Map<String, String>> doubleData(String dataSourceName, final String namespace, final String sql) {
        return this.execute(dataSourceName, new JdbcCallback<Map<String, Map<String, String>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, Map<String, String>> doInConnection(Connection c) {
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    Object dataTitle;
                    ps = c.prepareStatement(sql);
                    rs = ps.executeQuery();
                    HashMap result = new HashMap();
                    Map<String, String> val = null;
                    while (rs.next()) {
                        dataTitle = rs.getString(1);
                        String dataKey = rs.getString(2);
                        String dataVal = rs.getString(3);
                        String key = namespace + "." + (String)dataTitle;
                        if (result.containsKey(key)) {
                            val = (Map)result.get(key);
                            val.put(dataKey, dataVal);
                            continue;
                        }
                        val = new HashMap();
                        val.put(dataKey, dataVal);
                        result.put((CallSite)((Object)key), val);
                    }
                    dataTitle = result;
                    return dataTitle;
                }
                catch (SQLException e) {
                    log.error("SQLException220", (Throwable)e);
                    Map<String, Map<String, String>> map = null;
                    return map;
                }
                finally {
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException e) {
                        log.error("SQLException227", (Throwable)e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(String dataSourceName, JdbcCallback<T> callback) {
        Connection c = null;
        try {
            DataSource dataSource;
            if (!StringUtils.isEmpty((Object)dataSourceName)) {
                dataSource = SpringContextHelper.getBean(dataSourceName, DataSource.class);
                c = dataSource.getConnection();
            } else {
                c = this.dataSource.getConnection();
            }
            dataSource = callback.doInConnection(c);
            return (T)dataSource;
        }
        catch (SQLException e) {
            log.error("\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
            T t = null;
            return t;
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (SQLException e) {
                    log.error("SQLException247", (Throwable)e);
                }
            }
        }
    }

    private static interface JdbcCallback<T> {
        public T doInConnection(Connection var1);
    }
}

