/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.bdata.cache;

import com.elitesland.yst.bdata.util.BeanUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BDataPool {
    private static final Logger log = LoggerFactory.getLogger(BDataPool.class);
    public static final String singleKeyPre = "_000_000";
    private static Map<String, Map<String, String>> codeMap = new HashMap<String, Map<String, String>>();

    public static void setCodeMap(Map<String, Map<String, String>> data) {
        codeMap.putAll(data);
    }

    public static Map<String, Map<String, String>> getCodeMap() {
        return codeMap;
    }

    public static Map<String, String> getValue(String nameSpace) {
        Map<String, String> maps = BDataPool.getCodeMap().get(nameSpace);
        if (maps == null) {
            return Collections.emptyMap();
        }
        return maps;
    }

    public static String getValue(String nameSpace, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        Map<String, String> maps = BDataPool.getCodeMap().get(nameSpace);
        if (maps == null || maps.size() <= 0) {
            return null;
        }
        for (String k : maps.keySet()) {
            if (!key.equals(k)) continue;
            return maps.get(k);
        }
        return null;
    }

    public static Map<String, String> getMapValue(String nameSpace, String parentKey) {
        String k = nameSpace + "." + parentKey;
        Map<String, String> maps = BDataPool.getCodeMap().get(k);
        if (maps == null) {
            return Collections.emptyMap();
        }
        return maps;
    }

    public static String getValue(String nameSpace, String parentKey, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        Map<String, String> maps = BDataPool.getMapValue(nameSpace, parentKey);
        if (maps == null) {
            return null;
        }
        String result = maps.get(key);
        return result;
    }

    public static List<?> convert(List<?> list, String orgFieldName, String destFieldName, String namespace) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(orgFieldName, destFieldName);
        return BDataPool.convert(list, params, namespace);
    }

    public static List<?> convert(List<?> list, Map<String, String> params, String namespace) {
        if (StringUtils.isEmpty(list)) {
            return new ArrayList();
        }
        for (Object obj : list) {
            for (String key : params.keySet()) {
                String valueField = params.get(key);
                try {
                    String cacheKey = BeanUtils.getProperty(obj, (String)key);
                    String cacheVal = BDataPool.getValue(namespace, cacheKey);
                    BeanUtils.setPropertyLombok(obj, valueField, cacheVal);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        return list;
    }
}

