package com.elitesland.scp.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel("订单未收货入参")
public class ScpOrderUnRecvParamVO implements Serializable {
    private static final long serialVersionUID = -3973068104239068632L;

    @ApiModelProperty("门店ID")
    @NotNull(message = "门店ID不能为空")
    private Long storeId;

    @ApiModelProperty("日期")
    @NotNull(message = "日期不能为空")
    private LocalDateTime dateTime;
}
