package com.elitesland.scp.service.mrp;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.dto.mrp.ScpMrpDPlanCancelDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


@FeignClient(name = ScpApplication.NAME, path = ScpApplication.PATH + ScpMrpRpcService.PATH)
@Validated
public interface ScpMrpRpcService {
    String PATH = "/mrp";

    /**
     * 取消采购计划
     *
     * @param cancelDTO 入参
     * @return 结果
     */
    @PostMapping("/plan/cancel")
    ApiResult<Long> cancelPlan(@RequestBody ScpMrpDPlanCancelDTO cancelDTO);
}


