package com.elitesland.scp.enums;

/**
 * @Auther: Mark
 * @Date: 2024/5/6 11:29
 * @Description:
 */
public enum DayOfWeekEnum {
    MONDAY("MONDAY", "一", "周一"),
    TUESDAY("TUESDAY", "二", "周二"),
    WEDNESDAY("WEDNESDAY", "三", "周三"),
    THURSDAY("THURSDAY", "四", "周四"),
    FRIDAY("FRIDAY", "五", "周五"),
    SATURDAY("SATURDAY", "六", "周六"),
    SUNDAY("SUNDAY", "日", "周日");

    public String getCode() {
        return code;
    }

    public String getCodeName() {
        return codeName;
    }

    private final String code;
    private final String codeName;

    public String getDesc() {
        return desc;
    }

    private final String desc;

    DayOfWeekEnum(String code, String codeName, String desc) {
        this.code = code;
        this.codeName = codeName;
        this.desc = desc;
    }

    public static String getCode(String codeName) {
        for (DayOfWeekEnum dayOfWeekEnum : DayOfWeekEnum.values()) {
            if (dayOfWeekEnum.getCodeName().equals(codeName)) {
                return dayOfWeekEnum.getCode();
            }
        }
        return null;
    }

    public static String getDesc(String codeName) {
        for (DayOfWeekEnum dayOfWeekEnum : DayOfWeekEnum.values()) {
            if (dayOfWeekEnum.getCodeName().equals(codeName)) {
                return dayOfWeekEnum.getDesc();
            }
        }
        return null;
    }

    public static String getCodeName(String desc) {
        for (DayOfWeekEnum dayOfWeekEnum : DayOfWeekEnum.values()) {
            if (dayOfWeekEnum.getDesc().equals(desc)) {
                return dayOfWeekEnum.getCodeName();
            }
        }
        return null;
    }

}
