package com.elitesland.scp.dto.authority;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/27 11:15
 * @Description:
 */
@Data
@ApiModel("获取门店权限数据")
public class StoreAuthorityRespDTO implements Serializable {

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "门店id")
    private Long id;

    @ApiModelProperty(value = "门店编号")
    private String storeCode;

    @ApiModelProperty(value = "门店名称")
    private String storeName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "所属公司ID")
    private Long ouId;

    @ApiModelProperty(value = "所属公司名称")
    private String ouName;

    @ApiModelProperty(value = "所属公司编码")
    private String ouCode;


    /**
     * 门店类型
     */
    @ApiModelProperty(value = "门店类型")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE")
    private String storeType;
    private String storeTypeName;

    /**
     * 经营性质
     */
    @ApiModelProperty(value = "经营性质")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE2")
    private String storeType2;
    private String storeType2Name;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("品牌编码")
    private String brandCode;

    @ApiModelProperty("品牌名称")
    private String brandName;

    private List<ItemInfo> itemInfos;

    @Data
    public static class ItemInfo {

        @ApiModelProperty("商品编码")
        private String itemCode;

        @ApiModelProperty("商品名称")
        private String itemName;

        @ApiModelProperty("商品id")
        private Long itemId;

        @ApiModelProperty("含税单价")
        private BigDecimal price;

        @ApiModelProperty("销售单价（不含服务费）")
        private BigDecimal salePrice;

        @ApiModelProperty("销项税率")
        private BigDecimal taxRate;

        @ApiModelProperty("单位")
        private String uom;

        @ApiModelProperty("单位名称")
        private String uomName;

        @ApiModelProperty("供应商ID")
        private Long suppId;

        @ApiModelProperty("供应商编码")
        private String suppCode;

        @ApiModelProperty("供应商名称")
        private String suppName;

        @ApiModelProperty("门店编码")
        private String storeCode;

        @ApiModelProperty("仓配结算价")
        private BigDecimal costPrice;

        @ApiModelProperty("采购价")
        private BigDecimal purPrice;

        @ApiModelProperty("科技费价格")
        private BigDecimal tefPrice;

        @ApiModelProperty("营销费价格")
        private BigDecimal mefPrice;

        @ApiModelProperty("运营费价格")
        private BigDecimal oefPrice;

        @ApiModelProperty("是否收取项目费用")
        private Boolean isProjFeeCharged;

        @ApiModelProperty("科技服务费用归属公司")
        private String tefFeeOuCode;

        @ApiModelProperty("运营费服务费用归属公司")
        private String oefFeeOuCode;

        @ApiModelProperty("营销费服务费用归属公司")
        private String mefFeeOuCode;

        @ApiModelProperty("科技服务费用归属公司")
        private String tefFeeOuName;

        @ApiModelProperty("运营费服务费用归属公司")
        private String oefFeeOuName;

        @ApiModelProperty("营销费服务费用归属公司")
        private String mefFeeOuName;




    }
}
