package com.elitesland.scp.enums;

public enum ScpUdcEnum {

    DEMAND_SET_TYPE_0("yst-suplan", "DEMAND_SET_TYPE", "订货集类型", "0", "门店"),
    DEMAND_SET_TYPE_1("yst-suplan", "DEMAND_SET_TYPE", "订货集类型", "1", "仓库"),
    DEO_STATUS_WT("yst-suplan", "DEO_STATUS", "订货单状态", "WT", "未分配"),
    DEO_STATUS_DOING("yst-suplan", "DEO_STATUS", "订货单状态", "DOING", "部分分配"),
    DEO_STATUS_DONE("yst-suplan", "DEO_STATUS", "订货单状态", "DONE", "全部分配"),
    DEO_STATUS_PUSHING("yst-suplan", "DEO_STATUS", "订货单状态", "PUSHING", "部分推送"),
    DEO_STATUS_PUSHED("yst-suplan", "DEO_STATUS", "订货单状态", "PUSHED", "全部推送"),
    ;
    private final String model;
    private final String code;
    private final String codeName;
    private final String valueCode;
    private final String valueCodeName;

    ScpUdcEnum(final String model, final String code, final String codeName, final String valueCode, final String valueCodeName) {
        this.model = model;
        this.code = code;
        this.codeName = codeName;
        this.valueCode = valueCode;
        this.valueCodeName = valueCodeName;
    }

    public String getValueCodeName() {
        return valueCodeName;
    }

    public String getValueCode() {
        return valueCode;
    }

    public String getMsg() {
        return valueCodeName;
    }

    public String getModel() {
        return model;
    }

    public String getCode() {
        return code;
    }

    public String getCodeName() {
        return codeName;
    }
}
