package com.elitesland.scp.param;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 22日 11:33
 * @version: 1.0
 */
@Data
@ApiModel( description = "仓库关系查询rpc 参数")
public class ScpWhNetRelationRpcDtoParam implements Serializable {

    @ApiModelProperty(value = "类型")
    private List<String> types;

    @ApiModelProperty(value = "需求仓库编码/门店编码")
    private List<String> demandWhStCodes;

    @ApiModelProperty(value = "商品品类")
    private List<String> itemCateCodes;

    @ApiModelProperty(value = "商品编码")
    private List<String> itemCodes;

    @ApiModelProperty(value = "有效日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime validDate;







}
