package com.elitesland.scp.dto.supalloc;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 25日 11:46
 * @version: 1.0
 */
@Data
@ApiModel(value = "ScpSupplyAllocationRpcDTO", description = "供应商份额分配查询")
public class ScpSupplyAllocationRpcDTO extends BaseViewModel implements Serializable {

    @ApiModelProperty(value = "供应仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty(value = "供应商编码")
    private String suppCode;

    @ApiModelProperty(value = "供应商名称")
    private String suppName;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "类型名")
    private String typeName;

    @ApiModelProperty(value = "门店id/门店仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long storeWhId;

    @ApiModelProperty(value = "仓库编码/门店编码")
    private String storeWhCode;

    @ApiModelProperty(value = "仓库名称/门店名称")
    private String storeWhName;

    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;

    @ApiModelProperty(value = "商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "配额")
    private BigDecimal allocation;

    @ApiModelProperty(value = "最小订货量")
    private BigDecimal minimumOrderQuantity;

    @ApiModelProperty(value = "采购提前期")
    private BigDecimal purchaseLeadTime;

    @ApiModelProperty(value = "单位")
    private String unit;

    @ApiModelProperty(value = "单位名")
    private String unitName;

    @ApiModelProperty(value = "有效日期从")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "有效日期至")
    private LocalDateTime endTime;


}
