package com.elitesland.scp.boh;

import com.elitescloud.boot.mq.common.BaseMessage;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 门店订货回写 mq消息参数
 */
@Data
public class StoreReceiveApproveSendParam extends BaseMessage implements Serializable {

    public static final String APPROVE_CHANNEL = "store_order_approve";

    private String businessKey;

    @ApiModelProperty("单据类型，TRN：仓配-调拨单，GR：供应商直发-采购收货单")
    private String docType;

    private List<OrderDoc> orderDocs;

    @Data
    public static class OrderDoc implements Serializable {
        @ApiModelProperty("订货单id")
        private Long orderId;
        @ApiModelProperty("订货单单号")
        private String orderNo;
        @ApiModelProperty("业务单据id")
        private Long docId;
        @ApiModelProperty("业务单号")
        private String docNo;
        @ApiModelProperty("总金额")
        private BigDecimal totalAmt;
        @ApiModelProperty("业务单据创建时间")
        private LocalDateTime docCreateTime;
        @ApiModelProperty("明细")
        private List<OrderItem> items;
    }

    @Data
    public static class OrderItem implements Serializable {
        @ApiModelProperty("订货单明细id")
        private Long orderDid;
        @ApiModelProperty("业务单明细id")
        private Long did;
        @ApiModelProperty("业务单明细行号")
        private Integer lineNo;
        @ApiModelProperty("业务单据明细数量")
        private BigDecimal qty;
        @ApiModelProperty("商品id")
        private Long itemId;
    }
}
