package com.elitesland.scp.boh;

import com.elitescloud.boot.mq.common.BaseMessage;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 门店订货回写 mq消息参数
 */
@Data
public class StoreReceiveSendParam extends BaseMessage implements Serializable {

    public static final String DELIVERY_CHANNEL = "store_order_delivery";
    public static final String RECEIVE_CHANNEL = "store_order_receive";

    private String businessKey;
    private Long orderId;
    private Long docId;

    // 出库/发货回写
    private LocalDateTime deliveryDate;
    private BigDecimal totalOutQty;

    // 收货回写
    private LocalDateTime receiveDate;
    private BigDecimal totalInQty;

}
