package com.elitesland.scp.service.authority;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.dto.authority.ItemObject;
import com.elitesland.scp.dto.authority.StoreAuthorityRespDTO;
import com.elitesland.scp.dto.authority.StoreAuthorityRpcDTO;
import com.elitesland.scp.dto.authority.StoreAuthorityRpcPageDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @Auther: Mark
 * @Date: 2024/3/27 10:51
 * @Description:
 */
@FeignClient(name = ScpApplication.NAME, path = ScpApplication.PATH + StoreAuthorityRpcService.PATH)
@Validated
public interface StoreAuthorityRpcService {

    String PATH = ScpApplication.URI_PREFIX + "/authority";

    /**
     * 获取门店要货权限内数据，包含门店基本信息，商品数据，价格信息
     *
     * @param
     * @return
     */
    @PostMapping("/getStoreAuthorityData")
    ApiResult<StoreAuthorityRespDTO> getStoreAuthorityData(StoreAuthorityRpcDTO storeAuthorityRpcDTO);

    @PostMapping("/getStoreAuthorityPageData")
    ApiResult<PagingVO<ItemObject>> getStoreAuthorityDataPage(StoreAuthorityRpcPageDTO storeAuthorityRpcPageDTO);
}
