package com.elitesland.scp.service.order;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.dto.order.ScpDemandOrderDRpcAllocDTO;
import com.elitesland.scp.dto.order.ScpDemandOrderDRpcDTO;
import com.elitesland.scp.dto.order.ScpDemandOrderDRpcQuantityDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = ScpApplication.NAME, path = ScpApplication.PATH + ScpDemandOrderDRpcService.PATH)
@Validated
public interface ScpDemandOrderDRpcService {
    String PATH = "/orderDRpc";

    /**
     * 更新订货单明细
     *
     * @param rpcDTOS
     * @return
     */
    @PostMapping("/updateDemandOrderD")
    ApiResult<Long> updateDemandOrderDetail(@RequestBody List<ScpDemandOrderDRpcDTO> rpcDTOS);

    @PostMapping("/updateAllocationQuantity")
    ApiResult<Long> updateAllocationQuantity(@RequestBody List<ScpDemandOrderDRpcAllocDTO> rpcDTOS);

    @PostMapping("/updateQuantity")
    ApiResult<Long> updateQuantity(@RequestBody List<ScpDemandOrderDRpcQuantityDTO> rpcDTOS);
}


