package com.elitesland.scp.service.supalloc;


import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDTO;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDtoParam;
import com.elitesland.scp.service.order.ScpDemandOrderDRpcService;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author jeesie
 */
@FeignClient(name = ScpApplication.NAME, path = ScpApplication.PATH + ScpDemandOrderDRpcService.PATH)
@Validated
public interface ScpSupplyAllocationProvider {

    String PATH = ScpApplication.URI_PREFIX + "/supplyAlloc";

    @PostMapping("/findSupplyAllocationRpcByParam")
    List<ScpSupplyAllocationRpcDTO> findSupplyAllocationRpcByParam (@RequestBody ScpSupplyAllocationRpcDtoParam supplyAllocationRpcDtoParam);

}
