package com.elitesland.scp.boh;

import com.elitescloud.boot.mq.common.BaseMessage;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;

/**
 * 门店订货回写 mq消息参数
 */
@Data
public class StoreReceiveCreateSendParam extends BaseMessage implements Serializable {

    public static final String CREATE_CHANNEL = "store_order_create";

    private String uk = UUID.randomUUID().toString();

    private String businessKey;

    @ApiModelProperty("单据类型，TRN：仓配-调拨单，GR：供应商直发-采购收货单")
    private String docType;

    private List<OrderDoc> orderDocs;

    @Data
    public static class OrderDoc implements Serializable {
        @ApiModelProperty("订货单id")
        private Long orderId;
        @ApiModelProperty("订货单单号")
        private String orderNo;
        @ApiModelProperty("业务单据id")
        private Long docId;
        @ApiModelProperty("业务单号")
        private String docNo;

        @ApiModelProperty("订货单明细id集合")
        private List<Long> orderDidList;
    }
}
