package com.elitesland.scp.boh;

import com.elitescloud.boot.mq.common.BaseMessage;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;

@Data
public class StoreRtnApproveSendParam extends BaseMessage implements Serializable {

    public static final String STORE_RTN_CHANNEL = "store_rtn_approve";

    private String businessKey;
    private Long docId;

    private String uk = UUID.randomUUID().toString(); // 手动避免消息被判重

    private List<StoreRtnApproveSendParam.OrderItem> items;

    @Data
    public static class OrderItem implements Serializable {
        @ApiModelProperty("订货单明细id")
        private Long orderDid;
        @ApiModelProperty("业务单明细id")
        private Long did;
        @ApiModelProperty("业务单据明细发货数量")
        private BigDecimal qty;
        @ApiModelProperty("商品id")
        private Long itemId;
    }
}
