package com.elitesland.scp.dto.authority;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/4/1 11:29
 * @Description:
 */
@Data
@ApiModel("门店权限-商品数据")
public class ItemObject implements Serializable {

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;


    @JsonProperty("id")
    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("销项税率")
    private BigDecimal taxRate;

    @ApiModelProperty("基本单位")
    private String uom;

    @ApiModelProperty("单位名称")
    private String uomName;


    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("品牌名称")
    private String brandName;


    /**
     * 品类(SPU)编号
     */
    @ApiModelProperty("品类(SPU)编号")
    private String itemCateCode;

    /**
     * 品类(SPU)全路径名称
     */
    @ApiModelProperty("品类(SPU)全路径名称")
    private List<String> itemCatePathName;

    /**
     * 品类(SPU)全称
     */
    @ApiModelProperty("品类(SPU)全称")
    private String itemCateFullName;

    @ApiModelProperty("包装规格")
    private String packageSpec;

    @ApiModelProperty("SPU编码")
    private String spuCode;

    @ApiModelProperty("SPU名称")
    private String spuName;

    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String suppCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("辅助单位")
    private String uom2;

    @ApiModelProperty("辅助单位名称")
    private String uom2Name;

    @ApiModelProperty("商品分类")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String itemType;
    private String itemTypeName;
}
