package com.elitesland.scp.enums;

public enum ScpUdcEnum {

    DEMAND_SET_TYPE_0("yst-suplan", "DEMAND_SET_TYPE", "订货集类型", "0", "门店"),
    DEMAND_SET_TYPE_1("yst-suplan", "DEMAND_SET_TYPE", "订货集类型", "1", "仓库"),
    DEO_STATUS_WT("yst-suplan", "DEO_STATUS", "订货单状态", "WT", "未分配"),
    DEO_STATUS_DOING("yst-suplan", "DEO_STATUS", "订货单状态", "DOING", "部分分配"),
    DEO_STATUS_DONE("yst-suplan", "DEO_STATUS", "订货单状态", "DONE", "全部分配"),
    DEO_STATUS_PUSHING("yst-suplan", "DEO_STATUS", "订货单状态", "PUSHING", "部分推送"),
    DEO_STATUS_PUSHED("yst-suplan", "DEO_STATUS", "订货单状态", "PUSHED", "全部推送"),

    DEO_STATUS_PART_SHIP("yst-suplan", "DEO_STATUS", "订货单状态", "PART_SHIP", "部分发货"),
    DEO_STATUS_SHIP("yst-suplan", "DEO_STATUS", "订货单状态", "SHIP", "已发货"),
    DEO_STATUS_PART_RECV("yst-suplan", "DEO_STATUS", "订货单状态", "PART_RECV", "部分收货"),
    DEO_STATUS_RECV("yst-suplan", "DEO_STATUS", "订货单状态", "RECV", "已收货"),
    OB_DOC_CLS_ST("yst-suplan", "OB_DOC_CLS", "订货单类别", "ST", "门店订货单"),
    OB_DOC_CLS_WH("yst-suplan", "OB_DOC_CLS", "订货单类别", "WH", "仓库订货单"),
    SCPSMAN_AUTHORITY_TYPE_0("yst-suplan", "SCPSMAN_AUTHORITY_TYPE", "计划员权限类型", "0", "门店"),
    SCPSMAN_AUTHORITY_TYPE_1("yst-suplan", "SCPSMAN_AUTHORITY_TYPE", "计划员权限类型", "1", "仓库"),
    STORE_TYPE2_DIRECTSALE("yst-supp", "STORE_TYPE2", "经营性质", "DIRECTSALE", "直营"),
    STORE_TYPE2_JOIN("yst-supp", "STORE_TYPE2", "经营性质", "JOIN", "加盟"),

    SUPPLY_DEMAND_TYPE_WH("yst-suplan", "SUPPLY_DEMAND_TYPE", "供应类型", "WH", "仓库"),
    SUPPLY_DEMAND_TYPE_SUPP("yst-suplan", "SUPPLY_DEMAND_TYPE", "供应类型", "SUPP", "供应商"),
    CALENDAR_WORK_STATUS_W("yst-suplan","CALENDAR_WORK_STATUS","工作状态","W","工作"),
    CALENDAR_WORK_STATUS_E("yst-suplan","CALENDAR_WORK_STATUS","工作状态","E","空闲"),

    WH_STATUS_CLOSED("yst-inv","WH_STATUS","仓库状态","INACTIVE","停用"),
    COM_STATUS_ACTIVEORNO_ACTIVE("COM", "STATUS_ACTIVEORNO", "启用停用状态", "ACTIVE", "启用"),

    STK_ITM_STATUS_OK("yst-inv", "STK_ITM_STATUS", "库存状态", "OK", "合格"),
    STK_ITM_STATUS_PASS("yst-inv", "STK_ITM_STATUS", "库存状态", "PASS", "不合格"),
    STK_ITM_STATUS_QC("yst-inv", "STK_ITM_STATUS", "库存状态", "QC", "待检品"),

    ORDER_PRIORITY_SUPALLOC("yst-suplan", "ORDER_PRIORITY", "单据类型优先级", "SUPALLOC", "供应商份额分配"),
    ORDER_PRIORITY_WHNET("yst-suplan", "ORDER_PRIORITY", "单据类型优先级", "WHNET", "仓网供应关系"),


    PAY_STATUS_NO_PAY("yst-suplan", "PAY_STATUS", "付款状态", "NO_PAY", "无需支付"),
    PAY_STATUS_WAIT_PAY("yst-suplan", "PAY_STATUS", "付款状态", "WAIT_PAY", "待支付"),

    PAY_STATUS_PART_PAY("yst-suplan", "PAY_STATUS", "付款状态", "PART_PAY", "部分支付"),

    PAY_STATUS_PAYED("yst-suplan", "PAY_STATUS", "付款状态", "PAYED", "已付款"),
    ;
    private final String model;
    private final String code;
    private final String codeName;
    private final String valueCode;
    private final String valueCodeName;

    ScpUdcEnum(final String model, final String code, final String codeName, final String valueCode, final String valueCodeName) {
        this.model = model;
        this.code = code;
        this.codeName = codeName;
        this.valueCode = valueCode;
        this.valueCodeName = valueCodeName;
    }

    public String getValueCodeName() {
        return valueCodeName;
    }

    public String getValueCode() {
        return valueCode;
    }

    public String getMsg() {
        return valueCodeName;
    }

    public String getModel() {
        return model;
    }

    public String getCode() {
        return code;
    }

    public String getCodeName() {
        return codeName;
    }
}
