package com.elitesland.scp.dto.template;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Auther: Mark
 * @Date: 2024/5/14 09:54
 * @Description:
 */
@Data
@ApiModel(description = "可选模板列表")
public class DemandOrderListRpcParamDTO implements Serializable {

    @ApiModelProperty(value = "门店/仓库编码", required = true)
    @NotNull(message = "门店/仓库编码不允许为空")
    private String demandWhStCode;

    @ApiModelProperty(value = "类型，0:门店，1:仓库", required = true)
    @NotNull(message = "订货单类型不允许为空")
    private String type;

    @ApiModelProperty("订货模板编号(不支持模糊搜索)")
    private String demandTemCode;

    @ApiModelProperty("订货模板名称(支持模糊搜索)")
    private String demandTemName;


}
