package com.elitesland.scp.service.item;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.param.CateItemRpcParam;
import com.elitesland.scp.param.ScpCateItemSaleScopeSaveRpcParam;
import com.elitesland.scp.param.ScpWhNetRelationRpcSaveVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @description: TODO
 * @author: huruizhong
 * @modified By: huruizhong
 * @date: Created in 2024/4/3 3:53 下午
 * @version:v1.0
 */
@FeignClient(name = ScpApplication.NAME, path = ScpApplication.PATH + CateItemRpcService.PATH)
@Validated
public interface CateItemRpcService {

    String PATH = "/cate/item";

    @PostMapping("/listItemCode")
    ApiResult<List<String>> findItemCodesBy(@RequestBody CateItemRpcParam cateItemRpcParam);

    @PostMapping("/listItem")
    ApiResult<List<ScpCateItemDTO>> listByParam(@RequestBody CateItemRpcParam cateItemRpcParam);

    @PostMapping("/saveSaleScope")
    ApiResult<String> saveSaleScope(@RequestBody List<ScpCateItemSaleScopeSaveRpcParam> paramList);

}
