package com.elitesland.scp.param;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author chaofeng.xia
 * @since 2025/5/20
 */
@Data
@ApiModel("仓网关系保存/修改")
public class ScpWhNetRelationRpcSaveVO extends BaseViewModel implements Serializable {

    @ApiModelProperty(value = "供应仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long supplyWhId;

    @ApiModelProperty(value = "供应仓库编码")
    private String supplyWhCode;

    @ApiModelProperty(value = "供应仓库名称")
    private String supplyWhName;

    @ApiModelProperty(value = "供应仓库公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long supplyWhOuId;

    @ApiModelProperty(value = "供应仓库公司编码")
    private String supplyWhOuCode;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "需求门店id/门店仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long demandWhStId;

    @ApiModelProperty(value = "需求仓库编码/门店编码")
    private String demandWhStCode;

    @ApiModelProperty(value = "需求仓库名称/门店名称")
    private String demandWhStName;

    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;

    @ApiModelProperty(value = "商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "转移提前期")
    private BigDecimal transferLeadTime;

    @ApiModelProperty(value = "供应百分比")
    private BigDecimal supplyPercentage;

    @ApiModelProperty(value = "供应百分比之和")
    private BigDecimal supplyPercentageSum;

    @ApiModelProperty(value = "有效日期从")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "有效日期至")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "行号")
    private Integer lineNo;

    @ApiModelProperty(value = "状态（启用/禁用）")
    private Boolean status;

    @ApiModelProperty("销售公司编码")
    private String ouCode;

    @ApiModelProperty("销售公司名称")
    private String ouName;

    @ApiModelProperty("配送类型")
    private String deliveryType;

    @ApiModelProperty(value = "需求（仓库/门店）所属公司id")
    private Long demandWhStOuId;

    @ApiModelProperty(value = "需求（仓库/门店）所属公司编码")
    private String demandWhStOuCode;
}
