package com.elitesland.scp.service.scpsman;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.dto.scpsman.SalesmanInfoRpcSaveVo;
import com.elitesland.scp.dto.scpsman.ScpsmanGrantedRegionDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;

/**
 * @author chaofeng.xia
 * @since 2025/8/4
 */
@FeignClient(name = ScpApplication.NAME, path = ScpApplication.PATH + ScpsmanRpcService.PATH)
@Validated
public interface ScpsmanRpcService {

    String PATH = "/scpsman";

    @PostMapping("/saveAndAuthority")
    ApiResult<Long> saveAndAuthority(@RequestBody SalesmanInfoRpcSaveVo saveVo);

    @GetMapping(value = "/grantedRegion")
    ApiResult<ScpsmanGrantedRegionDTO> getGrantedRegion(@NotBlank @RequestParam("scpsmanNo") String scpsmanNo);
}
