package com.elitesland.scp.enums;

public enum ScpUdcEnum {

    DEMAND_SET_TYPE_0("yst-suplan", "DEMAND_SET_TYPE", "订货集类型", "0", "门店"),
    DEMAND_SET_TYPE_1("yst-suplan", "DEMAND_SET_TYPE", "订货集类型", "1", "仓库"),
    DEO_STATUS_DRAFT("yst-suplan", "DEO_STATUS", "订货单状态", "DRAFT", "草稿"),
    DEO_STATUS_WT("yst-suplan", "DEO_STATUS", "订货单状态", "WT", "未分配"),
    DEO_STATUS_DOING("yst-suplan", "DEO_STATUS", "订货单状态", "DOING", "部分分配"),
    DEO_STATUS_DONE("yst-suplan", "DEO_STATUS", "订货单状态", "DONE", "全部分配"),
    DEO_STATUS_PUSHING("yst-suplan", "DEO_STATUS", "订货单状态", "PUSHING", "部分推送"),
    DEO_STATUS_PUSHED("yst-suplan", "DEO_STATUS", "订货单状态", "PUSHED", "全部推送"),
    DEO_STATUS_TIMEOUT("yst-suplan", "DEO_STATUS", "订货单状态", "TIMEOUT", "已超时"),

    COM_APPLY_STATUS_DRAFT("yst-suplan", "DEO_STATUS", "订货单状态", "DRAFT", "未提交"),
    COM_APPLY_STATUS_DOING("yst-suplan", "DEO_STATUS", "订货单状态", "DOING", "审批中"),
    COM_APPLY_STATUS_REJECTED("yst-suplan", "DEO_STATUS", "订货单状态", "REJECTED", "已拒绝"),
    COM_APPLY_STATUS_VOID("yst-suplan", "DEO_STATUS", "订货单状态", "VOID", "作废"),
    COM_APPLY_STATUS_COMPLETE("yst-suplan", "DEO_STATUS", "订货单状态", "COMPLETE", "完成"),

    DEO_STATUS_PART_SHIP("yst-suplan", "DEO_STATUS", "订货单状态", "PART_SHIP", "部分发货"),
    DEO_STATUS_SHIP("yst-suplan", "DEO_STATUS", "订货单状态", "SHIP", "已发货"),
    DEO_STATUS_PART_RECV("yst-suplan", "DEO_STATUS", "订货单状态", "PART_RECV", "部分收货"),
    DEO_STATUS_RECV("yst-suplan", "DEO_STATUS", "订货单状态", "RECV", "已收货"),
    DEO_STATUS_PART_CLOSE("yst-suplan", "DEO_STATUS", "订货单状态", "PART_CLOSE", "部分取消"),
    DEO_STATUS_CLOSE("yst-suplan", "DEO_STATUS", "订货单状态", "CLOSE", "已取消"),
    OB_DOC_CLS_ST("yst-suplan", "OB_DOC_CLS", "订货单类别", "ST", "门店订货单"),
    OB_DOC_CLS_WH("yst-suplan", "OB_DOC_CLS", "订货单类别", "WH", "仓库订货单"),
    SCPSMAN_AUTHORITY_TYPE_0("yst-suplan", "SCPSMAN_AUTHORITY_TYPE", "计划员权限类型", "0", "门店"),
    SCPSMAN_AUTHORITY_TYPE_1("yst-suplan", "SCPSMAN_AUTHORITY_TYPE", "计划员权限类型", "1", "仓库"),
    STORE_TYPE2_DIRECTSALE("yst-supp", "STORE_TYPE2", "经营性质", "DIRECTSALE", "直营"),
    STORE_TYPE2_JOIN("yst-supp", "STORE_TYPE2", "经营性质", "JOIN", "加盟"),

    SCPSMAN_AUTH_SOURCE_MANUAL("yst-suplan", "AUTH_SOURCE", "计划员权限来源", "MANUAL", "手工分配"),
    SCPSMAN_AUTH_SOURCE_EMP_STORE("yst-suplan", "AUTH_SOURCE", "计划员权限来源", "EMP_STORE", "员工所属门店"),
    SCPSMAN_AUTH_SOURCE_EMP_REGION("yst-suplan", "AUTH_SOURCE", "计划员权限来源", "EMP_REGION", "员工所属区域"),

    SUPPLY_DEMAND_TYPE_WH("yst-suplan", "SUPPLY_DEMAND_TYPE", "供应类型", "WH", "仓库"),
    SUPPLY_DEMAND_TYPE_SUPP("yst-suplan", "SUPPLY_DEMAND_TYPE", "供应类型", "SUPP", "供应商"),
    CALENDAR_WORK_STATUS_W("yst-suplan","CALENDAR_WORK_STATUS","工作状态","W","工作"),
    CALENDAR_WORK_STATUS_E("yst-suplan","CALENDAR_WORK_STATUS","工作状态","E","空闲"),

    WH_STATUS_CLOSED("yst-inv","WH_STATUS","仓库状态","INACTIVE","停用"),
    COM_STATUS_ACTIVEORNO_ACTIVE("COM", "STATUS_ACTIVEORNO", "启用停用状态", "ACTIVE", "启用"),

    STK_ITM_STATUS_OK("yst-inv", "STK_ITM_STATUS", "库存状态", "OK", "合格"),
    STK_ITM_STATUS_PASS("yst-inv", "STK_ITM_STATUS", "库存状态", "PASS", "不合格"),
    STK_ITM_STATUS_QC("yst-inv", "STK_ITM_STATUS", "库存状态", "QC", "待检品"),

    ORDER_PRIORITY_SUPALLOC("yst-suplan", "ORDER_PRIORITY", "单据类型优先级", "SUPALLOC", "供应商份额分配"),
    ORDER_PRIORITY_WHNET("yst-suplan", "ORDER_PRIORITY", "单据类型优先级", "WHNET", "仓网供应关系"),


    PAY_STATUS_NO_PAY("yst-suplan", "PAY_STATUS", "付款状态", "NO_PAY", "无需支付"),
    PAY_STATUS_WAIT_PAY("yst-suplan", "PAY_STATUS", "付款状态", "WAIT_PAY", "待支付"),
    PAY_STATUS_PAYING("yst-suplan", "PAY_STATUS", "付款状态", "PAYING", "支付中"),
    PAY_STATUS_PART_PAY("yst-suplan", "PAY_STATUS", "付款状态", "PART_PAY", "部分支付"),
    PAY_STATUS_PAYED("yst-suplan", "PAY_STATUS", "付款状态", "PAYED", "已付款"),

    SCP_MESSAGE_CATEGORY_DEFAULT("yst-suplan", "MESSAGE_CATEGORY", "消息分类", "DEF", "默认"),

    CALENDAR_SET_STATUS_DR("yst-suplan", "CALENDAR_SET_STATUS", "门店订货日历配置状态", "DR", "草稿"),
    CALENDAR_SET_STATUS_APPRING("yst-suplan", "CALENDAR_SET_STATUS", "门店订货日历配置状态", "APPRING", "审批中"),
    CALENDAR_SET_STATUS_COMPLETE("yst-suplan", "CALENDAR_SET_STATUS", "门店订货日历配置状态", "COMPLETE", "审批完成"),
    CALENDAR_SET_STATUS_REJECTED("yst-suplan", "CALENDAR_SET_STATUS", "门店订货日历配置状态", "REJECTED", "已拒绝"),

    MRP_PUSH_STATUS_NOT("yst-suplan", "MRP_PUSH_STATUS", "物料需求计划推送状态", "NOT", "未推送"),
    MRP_PUSH_STATUS_PART("yst-suplan", "MRP_PUSH_STATUS", "物料需求计划推送状态", "PART", "部分推送"),
    MRP_PUSH_STATUS_COMPLETE("yst-suplan", "MRP_PUSH_STATUS", "物料需求计划推送状态", "COMPLETE", "推送完成"),

    MRP_CALC_STATUS_PROCESS("yst-suplan", "MRP_CALC_STATUS", "物料需求计划计算状态", "PROCESS", "计算中"),
    MRP_CALC_STATUS_FAIL("yst-suplan", "MRP_CALC_STATUS", "物料需求计划计算状态", "FAIL", "计算失败"),
    MRP_CALC_STATUS_SUCCESS("yst-suplan", "MRP_CALC_STATUS", "物料需求计划计算状态", "SUCCESS", "计算成功"),

    MRP_D_PUSH_STATUS_NO("yst-suplan", "MRP_D_PUSH_STATUS", "物料需求计划明细推送状态", "NO", "无需推送"),
    MRP_D_PUSH_STATUS_NOT("yst-suplan", "MRP_D_PUSH_STATUS", "物料需求计划明细推送状态", "NOT", "未推送"),
    MRP_D_PUSH_STATUS_FAIL("yst-suplan", "MRP_D_PUSH_STATUS", "物料需求计划明细推送状态", "FAIL", "推送失败"),
    MRP_D_PUSH_STATUS_SUCCESS("yst-suplan", "MRP_D_PUSH_STATUS", "物料需求计划明细推送状态", "SUCCESS", "推送成功"),


    SERVICE_CONFIG_TYPE_STORE("yst-suplan", "SERVICE_CONFIG_TYPE", "项目服务配置类型", "STORE", "门店"),
    SERVICE_CONFIG_TYPE_REGION("yst-suplan", "SERVICE_CONFIG_TYPE", "项目服务配置类型", "REGION", "区域"),

    CALENDAR_TYPE_STORE("yst-suplan", "CALENDAR_CONFIG_METHOD", "日历配置方式", "STORE", "门店"),
    CALENDAR_TYPE_REGION("yst-suplan", "CALENDAR_CONFIG_METHOD", "日历配置方式", "REGION", "区域"),


    ITM_ITM_TYPE2_110("yst-supp", "ITEM_TYPE2", "配送类型", "110", "区配"),
    ITM_ITM_TYPE2_120("yst-supp", "ITEM_TYPE2", "配送类型", "120", "统配"),
    ITM_ITM_TYPE2_130("yst-supp", "ITEM_TYPE2", "配送类型", "130", "直送"),
    ITM_ITM_TYPE2_140("yst-supp", "ITEM_TYPE2", "配送类型", "140", "甲指乙采"),
    ITM_ITM_TYPE2_150("yst-supp", "ITEM_TYPE2", "配送类型", "150", "水果"),

    ITM_ITM_TYPE_10("ITM", "ITM_TYPE", "商品类型", "10", "实物类商品"),
    ITM_ITM_TYPE_20("ITM", "ITM_TYPE", "商品类型", "20", "服务类商品"),
    ITM_ITM_TYPE_30("ITM", "ITM_TYPE", "商品类型", "30", "虚拟商品"),
    ITM_ITM_TYPE_70("ITM", "ITM_TYPE", "商品类型", "70", "组合商品"),

    BUSINESS_TYPE_10("yst-suplan", "BUSINESS_TYPE", "业务类型", "10", "新店首批物料"),
    BUSINESS_TYPE_20("yst-suplan", "BUSINESS_TYPE", "业务类型", "20", "首批设备"),
    BUSINESS_TYPE_30("yst-suplan", "BUSINESS_TYPE", "业务类型", "30", "老店增补"),
    BUSINESS_TYPE_40("yst-suplan", "BUSINESS_TYPE", "业务类型", "40", "门店自采"),
    BUSINESS_TYPE_50("yst-suplan", "BUSINESS_TYPE", "业务类型", "50", "门店装修"),

    SURVEY_STATUS_10("yst-suplan", "SURVEY_STATUS", "问卷状态", "10", "草稿"),
    SURVEY_STATUS_20("yst-suplan", "SURVEY_STATUS", "问卷状态", "20", "已发布"),
    SURVEY_STATUS_30("yst-suplan", "SURVEY_STATUS", "问卷状态", "30", "作废"),
    SURVEY_STATUS_40("yst-suplan", "SURVEY_STATUS", "问卷状态", "40", "失效"),

    SURVEY_FILL_STATUS_10("yst-suplan", "SURVEY_FILL_STATUS", "问卷填写状态", "10", "已填写"),
    SURVEY_FILL_STATUS_00("yst-suplan", "SURVEY_FILL_STATUS", "问卷填写状态", "00", "未填写"),

    SURVEY_QUESTION_TYPE_10("yst-suplan", "SURVEY_QUESTION_TYPE", "问卷问题类型", "10", "单选题"),
    SURVEY_QUESTION_TYPE_20("yst-suplan", "SURVEY_QUESTION_TYPE", "问卷问题类型", "20", "多选题"),
    SURVEY_QUESTION_TYPE_30("yst-suplan", "SURVEY_QUESTION_TYPE", "问卷问题类型", "30", "填空题"),

    ;
    private final String model;
    private final String code;
    private final String codeName;
    private final String valueCode;
    private final String valueCodeName;

    ScpUdcEnum(final String model, final String code, final String codeName, final String valueCode, final String valueCodeName) {
        this.model = model;
        this.code = code;
        this.codeName = codeName;
        this.valueCode = valueCode;
        this.valueCodeName = valueCodeName;
    }

    public String getValueCodeName() {
        return valueCodeName;
    }

    public String getValueCode() {
        return valueCode;
    }

    public String getMsg() {
        return valueCodeName;
    }

    public String getModel() {
        return model;
    }

    public String getCode() {
        return code;
    }

    public String getCodeName() {
        return codeName;
    }
}
