package com.elitesland.scp.boh;

import com.elitescloud.boot.mq.common.BaseMessage;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;

/**
 * 中台收货、退货回写 mq消息参数
 */
@Data
public class StoreReceiveConfirmSendParam extends BaseMessage implements Serializable {

    public static final String CONFIRM_CHANNEL = "store_order_confirm";

    private String uk = UUID.randomUUID().toString();

    private String businessKey;

    @ApiModelProperty("单据类型，TRN：仓配-调拨单，GR：供应商直发-采购收货单")
    private String docType;

    @ApiModelProperty("业务单据id")
    private Long docId;
    @ApiModelProperty("业务单号")
    private String docNo;

    @ApiModelProperty("收货单ID")
    private Long receiveDocId;

    @ApiModelProperty("收货单号")
    private String receiveDocNo;

    @ApiModelProperty("退货类型")
    private String refundType;
    
    @ApiModelProperty("业务单据创建时间")
    private LocalDateTime confirmTime;

    @ApiModelProperty("明细")
    private List<OrderItem> items;

    @Data
    public static class OrderItem implements Serializable {
        @ApiModelProperty("订货单明细id")
        private Long orderDid;
        @ApiModelProperty("业务单明细id")
        private Long did;
        @ApiModelProperty("业务单据明细数量")
        private BigDecimal qty;
        @ApiModelProperty("商品id")
        private Long itemId;
    }
}
