package com.elitesland.scp.service.template;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.dto.template.DemandOrderDetailRpcParamDTO;
import com.elitesland.scp.dto.template.DemandOrderDetailRpcRespDTO;
import com.elitesland.scp.dto.template.DemandOrderListRpcParamDTO;
import com.elitesland.scp.dto.template.DemandOrderListRpcRespDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/5/14 09:45
 * @Description:
 */
@FeignClient(name = ScpApplication.NAME, path = ScpApplication.PATH + DemandTemplateRpcService.PATH)
@Validated
public interface DemandTemplateRpcService {

    String PATH = "/template/demand";

    /**
     * 根据编码和类型获取可选的模板，支持按照模板编码和名称进一步过滤搜索结果
     *
     * @param
     * @return
     */
    @PostMapping("/list")
    ApiResult<List<DemandOrderListRpcRespDTO>> list(@Validated DemandOrderListRpcParamDTO dto);

    /**
     * 根据id或者编码查询模板配置详情
     *
     * @param
     * @return
     */
    @PostMapping("/detail")
    ApiResult<DemandOrderDetailRpcRespDTO> detail(DemandOrderDetailRpcParamDTO dto);

}
