package com.elitesland.scp.service.whnet;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.param.ScpWhNetRelationParam;
import com.elitesland.scp.param.ScpWhNetRelationRpcDtoParam;
import com.elitesland.scp.param.ScpWhNetRelationRpcSaveVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author jeesie
 */
@Validated
@FeignClient(name = ScpApplication.NAME,path = ScpApplication.PATH + ScpWhNetRelationProvider.PATH)
public interface ScpWhNetRelationProvider {

    String PATH = "/whnet";


    @PostMapping("/findWhNetRelationRpcDtoByParam")
    List<ScpWhNetRelationRpcDTO> findWhNetRelationRpcDtoByParam(ScpWhNetRelationRpcDtoParam scpWhNetRelationRpcDtoParam);

    /**
     * 外部调用--批量需求门店编码查询仓网关系
     * @param scpWhNetRelationParam
     * @return
     */
    @PostMapping("/outFindWhNetRelationRpcDtoByParam")
    List<ScpWhNetRelationRpcDTO> outFindWhNetRelationRpcDtoByParam(@RequestBody ScpWhNetRelationParam scpWhNetRelationParam);

    @PostMapping("/batchSave")
    ApiResult<String> batchSaveWhNetRelation(@RequestBody List<ScpWhNetRelationRpcSaveVO> saveVOList);

}
