package com.elitesland.scp.boh;

import com.elitescloud.boot.mq.common.BaseMessage;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;

/**
 * 门店订货回写 mq消息参数
 */
@Data
public class StoreReceiveSendParam extends BaseMessage implements Serializable {

    public static final String DELIVERY_CHANNEL = "store_order_delivery";
    public static final String RECEIVE_CHANNEL = "store_order_receive";
    public static final String CANCEL_CHANNEL = "store_order_cancel";

    private String uk = UUID.randomUUID().toString();

    private String businessKey;
    private Long orderId;
    private Long docId;

    // 出库/发货回写
    private LocalDateTime deliveryDate;
    private BigDecimal totalOutQty;

    // 收货回写
    private LocalDateTime receiveDate;
    private BigDecimal totalInQty;

    @ApiModelProperty("退货类型")
    private String refundType;

    private String docNo;
    private LocalDateTime createTime;
    private String orderNo;
    private String docType;

    private List<OrderItem> items;

    @Data
    public static class OrderItem implements Serializable {
        @ApiModelProperty("订货单明细id")
        private Long orderDid;
        @ApiModelProperty("业务单明细id")
        private Long did;
        @ApiModelProperty("业务单据明细发货数量")
        private BigDecimal qty;
        @ApiModelProperty("商品id")
        private Long itemId;
    }
}
