package com.elitesland.scp.service.order;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.dto.order.*;
import com.elitesland.scp.param.ScpOrderUnRecvParamVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = ScpApplication.NAME, path = ScpApplication.PATH + ScpDemandOrderDRpcService.PATH)
@Validated
public interface ScpDemandOrderDRpcService {
    String PATH = "/orderDRpc";

    /**
     * 更新订货单明细
     *
     * @param rpcDTOS
     * @return
     */
    @PostMapping("/updateDemandOrderD")
    ApiResult<Long> updateDemandOrderDetail(@RequestBody List<ScpDemandOrderDRpcDTO> rpcDTOS);

    @PostMapping("/updateAllocationQuantity")
    ApiResult<Long> updateAllocationQuantity(@RequestBody List<ScpDemandOrderDRpcAllocDTO> rpcDTOS);

    @PostMapping("/updateQuantity")
    ApiResult<Long> updateQuantity(@RequestBody List<ScpDemandOrderDRpcQuantityDTO> rpcDTOS);

    @PostMapping("/updateSrcDoc2No")
    ApiResult<String> updateSrcDoc2No(@RequestBody List<ScpDemandOrderDRpcSrcDoc2NoDTO> rpcDTOS);

    /**
     * 更新收货数量
     *
     * @param rpcDTOS
     * @return
     */
    @PostMapping("/updateRecvQty")
    ApiResult<Long> updateRecvQty(@RequestBody List<ScpDemandOrderDRpcRecvQtyDTO> rpcDTOS);

    /**
     * 取消订单
     *
     * @param cancelDTO
     * @return
     */
    @PostMapping("/cancel")
    ApiResult<Long> cancelOrder(@RequestBody ScpDemandOrderCancelDTO cancelDTO);

    /**
     * 支付回传
     *
     * @param cancelDTO
     * @return
     */
    @PostMapping("/pay/callback")
    ApiResult<Long> payCallback(@RequestBody ScpDemandOrderCancelDTO cancelDTO);

    /**
     * 检查待收货单据
     *
     * @param paramVO
     * @return
     */
    @PostMapping("/unRecv")
    ApiResult<Long> checkUnRecvOrder(@RequestBody ScpOrderUnRecvParamVO paramVO);

    @GetMapping("/findByMasId")
    ApiResult<List<ScpDemandOrderDRpcDTO>> findByMasId(@RequestParam("masId") Long masId);
    /**
     * 更加 订单编码集合 查询
     */
    @GetMapping("/findByDocNos")
    ApiResult<List<ScpDemandOrderRpcDTO>> findByDocNos(@RequestParam("DocNos") List<String> docNos);
}


