package com.elitesland.scp.service.order;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.dto.order.*;
import com.elitesland.scp.param.ScpDemandOrderRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = ScpApplication.NAME, path = ScpApplication.PATH + ScpDemandOrderRpcService.PATH)
@Validated
public interface ScpDemandOrderRpcService {
    String PATH = "/orderRpc";


    @GetMapping("/findById")
    ApiResult<ScpDemandOrderRpcDTO> findById(@RequestParam("id") Long id);

    @GetMapping("/updateAccAmt")
    ApiResult<Long> updateAccAmt(@RequestBody ScpDemandOrderRpcParam param);

    @GetMapping("/updatePayStatus")
    ApiResult<Object> updatePayStatus(@RequestBody ScpDemandOrderRpcParam param);

    @GetMapping("/findCodeByPayStatus")
    ApiResult<List<String>> findCodeByPayStatus(@RequestParam("payStatus") String payStatus);

    @GetMapping("/autoRecvFlag")
    ApiResult<Boolean> autoRecvFlag(@RequestParam("troId") Long troId);
}


