package com.elitesland.scp.enums;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 19:30
 * @Description:
 */
public enum UdcEnum {

    /**
     * 区域
     */
    CRM_CUST_REGION_HN_NORTH("yst-supp", "REGION", "区域", "HN_NORTH", "豫南"),
    CRM_CUST_REGION_HN_SOUTH("yst-supp", "REGION", "区域", "HN_SOUTH", "豫北"),
    CRM_CUST_REGION_ZJ_NORTH("yst-supp", "REGION", "区域", "ZJ_NORTH", "浙南"),
    CRM_CUST_REGION_ZJ_SOUTH("yst-supp", "REGION", "区域", "ZJ_SOUTH", "浙北"),

    /**
     * 计划员类型
     */
    SALE_SCPSMAN_TYPE_CHIEF("yst-suplan", "SCPSMAN_TYPE", "计划员类型", "CHIEF", "总监"),
    SALE_SCPSMAN_TYPE_PRMANAGER("yst-suplan", "SCPSMAN_TYPE", "计划员类型", "PRMANAGER", "省区经理"),
    SALE_SCPSMAN_TYPE_REMANAGER("yst-suplan", "SCPSMAN_TYPE", "计划员类型", "REMANAGER", "区域经理"),
    SALE_SCPSMAN_TYPE_SCPSMAN("yst-suplan", "SCPSMAN_TYPE", "计划员类型", "SCPSMAN", "二级计划员"),

    //客户状态
    CRM_CUST_STATUS_ACTIVE("yst-suplan", "CUST_STATUS", "客户状态", "ACTIVE", "启用"),
    CRM_CUST_STATUS_CLOSED("yst-suplan", "CUST_STATUS", "客户状态", "CLOSED", "禁用"),

    //员工类型
    CUST_TYPE_SCPSMAN("yst-sys", "employeeType", "员工类型", "SCPSMAN", "计划员"),

    DEMAND_SET_TYPE_0("yst-suplan", "DEMAND_SET_TYPE", "类型", "0", "门店"),
    DEMAND_SET_TYPE_1("yst-suplan", "DEMAND_SET_TYPE", "仓库", "1", "仓库"),

    PUR_PO_GEN_TYPE_MRP("PUR", "PO_GEN_TYPE", "采购来源", "MRP", "MRP计划"),

    ;


    private final String model;
    private final String code;
    private final String codeName;
    private final String valueCode;
    private final String valueCodeName;

    UdcEnum(final String model, final String code, final String codeName, final String valueCode, final String valueCodeName) {
        this.model = model;
        this.code = code;
        this.codeName = codeName;
        this.valueCode = valueCode;
        this.valueCodeName = valueCodeName;
    }

    public static String getValueCodeByName(String model,String code,String valueName){
        for(UdcEnum udcEnum:UdcEnum.values()){
            if (udcEnum.getModel().equals(model) && udcEnum.getCode().equals(code)
                    && udcEnum.getValueCodeName().equals(valueName)) {
                return udcEnum.getValueCode();
            }
        }
        return null;
    }

    public String getValueCodeName() {
        return valueCodeName;
    }

    public String getValueCode() {
        return valueCode;
    }

    public String getMsg() {
        return valueCodeName;
    }

    public String getModel() {
        return model;
    }

    public String getCode() {
        return code;
    }

    public String getCodeName() {
        return codeName;
    }
}
