package com.elitesland.scp.service.order;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.dto.both.StoreRtnConfirmRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = ScpApplication.NAME, path = ScpApplication.PATH + ScpDemandOrderDRpcService.PATH)
@Validated
public interface StoreReceiveProvider {
    String PATH = "/rtn";

    /**
     * 门店小程序确认退货（出库）
     *
     * @param paramVO
     * @return
     */
    @PostMapping("/rtnConfirm")
    ApiResult rtn(@RequestBody StoreRtnConfirmRpcParam paramVO);
}
