package com.elitesland.scp.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

@Data
@ApiModel(value = "商品列表查询入参")
public class AppItemRpcParamVO  implements Serializable {

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

    @ApiModelProperty(value = "商品品类编码集合")
    private List<String> itemCateCodes;

    @ApiModelProperty(name = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "状态")
    private Boolean status;

    @ApiModelProperty(value = "类型")
    private String itemType;

    @ApiModelProperty(value = "品牌")
    private String brand;

    @ApiModelProperty(value = "商品编码集合")
    private List<String> itemCodes;

    @ApiModelProperty(value = "商品id集合")
    private List<Long> itemIds;

    @ApiModelProperty(name = "倒序/正序")
    private String asc;

    @ApiModelProperty(name = "排序字段")
    private String column;

    @ApiModelProperty(name = "关键词")
    private String keyword;

    private Long spuId;

    @ApiModelProperty(name = "单据类型", required = true)
    @NotBlank(message = "单据类型不能为空")
    private String docType;

    @ApiModelProperty(name = "商品分类", hidden = true)
    private List<String> itemTypes;

    @ApiModelProperty(value = "仓库编码")
    private String whCode;

    @ApiModelProperty(value = "库存大于零")
    private Boolean filterStockGtZero;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;
}
