package com.elitesland.scp.service.order;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = ScpApplication.NAME, path = ScpApplication.PATH + ScpDemandOrderDRpcService.PATH)
@Validated
public interface StoreReceiveProvider {
    String PATH = "/rtn";

    /**
     * 门店小程序确认退货（出库）
     *
     * @return
     */
    @GetMapping("/rtnConfirm")
    ApiResult rtnConfirm(@RequestParam String purGrNo);
}
