package com.elitesland.scp.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
@ApiModel("账号查询参数")
public class QueryBalanceRpcParamVO implements Serializable {
    private static final long serialVersionUID = 6074350548106028859L;

    @ApiModelProperty(value = "品牌编号", required = true)
    private Long brandId;

    @ApiModelProperty(value = "账户编号", required = true)
    private String accountNo;

    @ApiModelProperty(value = "门店编号", required = true)
    @NotBlank(message = "门店编号不能为空")
    private String storeCode;


}
