package com.elitesland.scp.service.order;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.dto.order.*;
import com.elitesland.scp.param.ScpDemandOrderPageRpcParamVO;
import com.elitesland.scp.param.ScpDemandOrderTitlePageRpcRespVO;
import com.elitesland.scp.param.ScpOrderUnRecvParamVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = ScpApplication.NAME, path = ScpApplication.PATH + ScpDemandOrderRpcService.PATH)
@Validated
public interface ScpDemandOrderRpcService {
    String PATH = "/orderRpc";

    /**
     * 检查待收货单据
     *
     * @param paramVO
     * @return
     */
    @PostMapping("/page")
    ApiResult<PagingVO<ScpDemandOrderTitlePageRpcRespVO>> page(@RequestBody ScpDemandOrderPageRpcParamVO paramVO);
}


