package com.elitesland.scp.application.facade.vo.param.item;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "品类商品操作设置入参")
public class ScpCateItemOperationVisibleParam {

    @ApiModelProperty(value = "ID列表")
    @NotEmpty(message = "ID列表不能为空")
    private List<Long> idList;

    @ApiModelProperty(value = "是否启用限制")
    @NotNull(message = "是否启用限制不能为空")
    private Boolean limitFlag;

    @ApiModelProperty(value = "生效日期")
    private LocalDateTime dateStart;

    @ApiModelProperty(value = "失效日期")
    private LocalDateTime dateEnd;

    @ApiModelProperty(value = "门店")
    private List<String> storeCodes;

}
