package com.elitesland.scp.application.facade.vo.resp.msg;

import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Getter
@Setter
public abstract class BaseScpMessageDetailRespVO implements Serializable {
    private static final long serialVersionUID = 2574603338290969816L;

    @ApiModelProperty(value = "消息ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "消息标题", position = 2)
    private String title;

    @ApiModelProperty(value = "消息摘要", position = 3)
    private String summaries;

    @ApiModelProperty(value = "作者ID，为空则取当前用户", position = 4)
    private Long authorId;
    @ApiModelProperty(value = "作者名称", position = 4)
    private String authorName;

    @ApiModelProperty(value = "分类，[UDC]yst-suplan:MESSAGE_CATEGORY", position = 5)
    private String category;
    @ApiModelProperty(value = "分类名称", position = 5)
    private String categoryName;

    @ApiModelProperty(value = "消息类型", position = 6)
    private String messageType;

    @ApiModelProperty(value = "消息内容", position = 7)
    private String txt;

    @ApiModelProperty(value = "附件信息", position = 10)
    private List<FileObjRespVO<?>> files;

    @ApiModelProperty(value = "备注", position = 11)
    private String remark;
}
